/*********************************************************************
    Project:MG82F6D17-DEMO
    Author:YZY
			MG82F6D17 SSOP20_V10 EV Board (TH194A)
			CpuCLK=12MHz, SysCLK=12MHz
	Description:
			Through the IVREF 1.4v, calculate the P10 input voltage
	Note:

    Creat time::
    Modify::
    
*********************************************************************/
#include "MG82F6D17_CONFIG.h"

#define MCU_SYSCLK		12000000
#define MCU_CPUCLK		(MCU_SYSCLK)
#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35


/*************************************************
Function: 		char putchar (char c)   
Description: 	send for printf
Input:    		char c
Output:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
Function:     	void DelayXus(u16 xUs)
Description:   	dealyunit:us
Input:     			u8 Us -> *1us  (1~255)
Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
Function:     	void DelayXms(u16 xMs)
Description:    dealyunit:ms
Input:     			u16 xMs -> *1ms  (1~65535)
Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
	}
}

/***********************************************************************************
Function:   	u16 GetAdcData()
Description:	read ADC result of the current channel  
Input:   
Output:   		u16 :ADC Value
*************************************************************************************/
u16 GetAdcValue()
{
	WordTypeDef wAdcValue;
	__DRV_ADC_Start();								// set ADCS,Start ADC
    __DRV_ADC_PollForConversion();           		// wait ADC complete
    wAdcValue.B.BHigh=ADCDH;
    wAdcValue.B.BLow=ADCDL;
 	__DRV_ADC_ClearFlag();		           			// clear ADCI flag
 	return wAdcValue.W&0x0FFF;
}

void main ()
{
	u16 wADCValue;
	u32 dwTemp0,dwTemp1;

  System_Init(); 

  __DRV_IVREF_Cmd(ENABLE);						// Eanble IVREF 1.4V
  	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

  while(1)
  {
		DelayXms(500);
		LED_R = !LED_R;

		
		__DRV_ADC_PinMux_Select(INTERNAL_VERF);		// Set the ADC channel to IVR 1.4v
		dwTemp0=GetAdcValue();						// read ADC value
		
		__DRV_ADC_PinMux_Select(AIN0);		// Set the ADC channel to AIN0
		dwTemp1=GetAdcValue();		// read ADC value
		// calculate the P10(AIN0) input voltage
		wADCValue=(dwTemp1*1400L)/dwTemp0;
		// Output the result by UART
		printf("\nP10 V:%d",wADCValue);
  }
}
