/*********************************************************************
    Project:MG82F6D17-DEMO
    Author:YZY
			MG82F6D17 SSOP20_V10 EV Board (TH194A)
			CpuCLK=12MHz, SysCLK=12MHz
		  Description:
			  set WDT to do a reset when WDT counter overflow
		  Note:

    Creat time::
    Modify::
    
*********************************************************************/
#include "MG82F6D17_CONFIG.h"

#define MCU_SYSCLK		12000000
#define MCU_CPUCLK		(MCU_SYSCLK)
#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35

/*************************************************
Function:     	void DelayXus(u16 xUs)
Description:   	dealyunit:us
Input:     			u8 Us -> *1us  (1~255)
Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
Function:     	void DelayXms(u16 xMs)
Description:    dealyunit:ms
Input:     			u16 xMs -> *1ms  (1~65535)
Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
	}
}

void main ()
{
	u8 i;
  System_Init(); 
	__DRV_WDT_Cmd(ENABLE);	 // Enable WDT Counter
	__DRV_WDT_ClearCounter();// clear WDT
	LED_G_0=0;LED_G_1=0;LED_R=0;
	for(i=0;i<10;i++)
	{
		DelayXms(100);
		__DRV_WDT_ClearCounter();// clear WDT
	}
	LED_G_0=1;LED_G_1=1;LED_R=1;

   while(1)
   {
    for(i=0;i<10;i++)
    {
			DelayXms(200);
			LED_G_0=!LED_G_0;
			__DRV_WDT_ClearCounter();// clear WDT
		}
		LED_G_0=1;
		while(1)
		{ //  not clear WDT, will reset MCU
			LED_R=!LED_R;
			DelayXms(10);
		}
    }
}
