// DFUDlg.cpp : implementation file
//

#include "stdafx.h"
#include <process.h>
#include "hexeditbase.h"
#include "TCEdit.h"
#include "Profile.h"
#include "DFU.h"
#include "DFUDlg.h"
#include "Version.h"
#include "Enum.h"
#include "GenericFunc.h"
#include "DFUDLL.H"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define THREAD_WATCH_WAITIME      200                       // wq
#define MW_CHANGE_NOTIFICATION    WM_APP + 1                // ۩wqT

// Define return valug of the DownloadThread
#define UPGRADE_SUCCESSFULLY      0                         
#define DFU_RESET_TO_AP_FAIL      1
#define DFU_DOWNLOAD_FAIL         2
#define DFU_RESET_TO_ISP_FAIL     3

static UINT Indicators[] = {
    ID_INDICATOR_MESSAGE,   
    ID_INDICATOR_AP_VERSION
};

const TCHAR g_szAppTitle[]      = _T("DFU Application");
const TCHAR g_szDfuDllName[]    = _T("DFU.DLL");

TCHAR           g_szAppPath[MAX_PATH+1] = {0};              // The execute file path
CProfile        g_Profile;                                  
HMODULE         g_hDfuDll = NULL;
DOWNLOAD_FILE   g_DownloadFile;

MW_DFU_ResetToISP       pDFU_ResetToISP;                    // Function pointer of DFU_Reset_To_ISP
MW_DFU_ResetToAP        pDFU_ResetToAP;                     // Function pointer of DFU_Reset_To_AP
MW_DFU_Download         pDFU_Download;                      // Function pointer of DFU_Download
MW_DFU_GetPercentage    pDFU_GetPercentage;                 // Function pointer of DFU_GetPercentage
MW_DFU_Initialize       pDFU_Initialize;                    // Funciton pointer of DFU_Initialize
MW_DFU_Deinitialize     pDFU_Deinitialize;                  // Funciton pointer of DFU_Deinitialize

CFont g_NewFont;

unsigned int _stdcall DownloadThread(LPVOID lpParam);         // Download function
unsigned int uiDownloadThreadId;                               //
unsigned long hDownloadThread;  

unsigned int _stdcall WatchThread(LPVOID lpParam);
unsigned int uiWatchThreadId;
unsigned long hWatchThread;

volatile BOOL g_bStopWatchThread = FALSE;
volatile BOOL g_bInDownload = FALSE;
volatile BOOL g_bInProcess = FALSE;

struct THREAD_INFO
{
    DWORD Vid;
	DWORD Pid;
	DWORD Checksum;
	DWORD CodeSize;
	LPBYTE pDownloadBuffer;
} g_ThreadInfo;


/*
 *-----------------------------------------------------------------------------
 * Thread_Download                                                            
 *-----------------------------------------------------------------------------
 * description: A thread to do download firmware job. When reset to ISP and reset
 *              to AP, the thread waiting for a event to move on.
 * Parameter: None
 * Return: None
 *-----------------------------------------------------------------------------
 */
unsigned int _stdcall DownloadThread(LPVOID lpParam)
{	
	BOOL Result = 0;   
    THREAD_INFO * pInfo = (THREAD_INFO *)lpParam;

	if (g_bInProcess == FALSE)
		return 0;
    
	Result = pDFU_ResetToISP(pInfo->Vid, pInfo->Pid);	
	if (Result == DEVICE_HAS_BEEN_IN_ISP)
	{
		Result = TRUE;
	}

	if (Result == TRUE)
	{ 
		g_bInDownload = TRUE;
		Result = pDFU_Download(pInfo->pDownloadBuffer, 0, pInfo->CodeSize, pInfo->Checksum);   // The second parameter is never used again. Fill it with 0.
		g_bInDownload = FALSE;
		if (Result == TRUE)
		{            
		    Result = pDFU_ResetToAP();	                    
			if (Result == FALSE)
				Result = DFU_RESET_TO_AP_FAIL;
			else			
			    Result = UPGRADE_SUCCESSFULLY;
		}
		else
		{
			Result = DFU_DOWNLOAD_FAIL;
		}
	}
	else
	{
		Result = DFU_RESET_TO_ISP_FAIL;	    
	}
	g_bInProcess = FALSE;
    
	return Result;
}

unsigned int _stdcall WatchThread(LPVOID lpParam)
{    
	HANDLE hWatchHandle = INVALID_HANDLE_VALUE;
	DWORD dwWaitResult = ERROR_SUCCESS;
    DWORD dwWatichIntervalTime = 0;
	HWND hWnd = (HWND) lpParam;
	TCHAR szWatchDirectory[MAX_PATH] = {0};	
	PTCHAR pChar = NULL;

	_tcscpy(szWatchDirectory, g_DownloadFile.m_szFilePathName);	
	pChar = _tcsrchr(szWatchDirectory, '\\');
	if (pChar == NULL)
		return 1;
	else
	    *pChar = '\0';
	
    g_bStopWatchThread = FALSE;

    hWatchHandle = FindFirstChangeNotification(szWatchDirectory,               // directory to watch 
                                               FALSE,                          // do not watch the subtree 
                                               FILE_NOTIFY_CHANGE_LAST_WRITE); // watch file name changes 
     
    if (hWatchHandle == INVALID_HANDLE_VALUE) 
	{
		g_bStopWatchThread = TRUE;       
    }    
	dwWatichIntervalTime = THREAD_WATCH_WAITIME;
	
	while (g_bStopWatchThread == FALSE)
	{         
        dwWaitResult = WaitForSingleObject(hWatchHandle, dwWatichIntervalTime);        
  
        switch (dwWaitResult) 
		{ 
        case WAIT_OBJECT_0:                         

             GetFileLastWriteTime(&g_DownloadFile);
             if ((g_DownloadFile.m_CurLastWriteTime.dwHighDateTime != g_DownloadFile.m_PreLastWriteTime.dwHighDateTime) ||
                (g_DownloadFile.m_CurLastWriteTime.dwLowDateTime != g_DownloadFile.m_PreLastWriteTime.dwLowDateTime))
             {
                 ::SendMessage(hWnd,
				     	       MW_CHANGE_NOTIFICATION,					           
                               (WPARAM)0,
						       (LPARAM)(hWnd, IDC_COMBO_FILE_PATH));     
             }                                         		    
			 if (FindNextChangeNotification(hWatchHandle) == FALSE ) 
			 {				
                 FindCloseChangeNotification(hWatchHandle);
				 g_bStopWatchThread = TRUE;	
                 hWatchThread = NULL;			 
			 }           				    					
			 break;
		} 
	}	
    
	if (hWatchHandle != INVALID_HANDLE_VALUE) 
	    FindCloseChangeNotification (hWatchHandle);

    _endthreadex (1);
	return 1;	
}
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
    CAboutDlg();

// Dialog Data
    //{{AFX_DATA(CAboutDlg)
    enum { IDD = IDD_ABOUTBOX };
    //}}AFX_DATA

    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CAboutDlg)
    protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    //}}AFX_VIRTUAL

// Implementation
protected:
    //{{AFX_MSG(CAboutDlg)
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
    //{{AFX_DATA_INIT(CAboutDlg)
    //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDlg)
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
    //{{AFX_MSG_MAP(CAboutDlg)
        // No message handlers
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDFUDlg dialog

CDFUDlg::CDFUDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CDFUDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CDFUDlg)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
    m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDFUDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDFUDlg)
	DDX_Control(pDX, IDC_PROGRESS_PERCENTAGE, m_prgPercentage);
	DDX_Control(pDX, IDC_EDIT_CODE_BUFFER, m_edtCodeBuffer);
	DDX_Control(pDX, IDC_COMBO_FILE_PATH, m_cboFilePath);
    DDX_Control(pDX, IDC_EDIT_VID, m_edtVID);
    DDX_Control(pDX, IDC_COMBO_PID, m_cboPID);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDFUDlg, CDialog)
    //{{AFX_MSG_MAP(CDFUDlg)
    ON_WM_SYSCOMMAND()
    ON_WM_PAINT()
    ON_WM_QUERYDRAGICON()
	ON_CBN_DROPDOWN(IDC_COMBO_PID, OnDropdownComboPid)
	ON_BN_CLICKED(IDC_BUTTON_LOAD_FILE, OnButtonLoadFile)
	ON_CBN_SELCHANGE(IDC_COMBO_FILE_PATH, OnSelchangeComboFilePath)
	ON_BN_CLICKED(IDC_CHECK_INITIAL_LOAD, OnCheckInitialLoad)
	ON_BN_CLICKED(IDC_CHECK_AUTO_RELOAD, OnCheckAutoReload)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, OnButtonExit)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
    ON_WM_DROPFILES()
	ON_EN_CHANGE(IDC_EDIT_VID, OnChangeEditVid)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDFUDlg message handlers

BOOL CDFUDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    // Add "About..." menu item to system menu.

    // IDM_ABOUTBOX must be in the system command range.
    ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
    ASSERT(IDM_ABOUTBOX < 0xF000);

    CMenu* pSysMenu = GetSystemMenu(FALSE);
    if (pSysMenu != NULL)
    {
        CString strAboutMenu;
        strAboutMenu.LoadString(IDS_ABOUTBOX);
        /*
        if (!strAboutMenu.IsEmpty())
        {
            pSysMenu->AppendMenu(MF_SEPARATOR);
            pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
        }
        */
    }

    // Set the icon for this dialog.  The framework does this automatically
    //  when the application's main window is not a dialog
    SetIcon(m_hIcon, TRUE);         // Set big icon
    SetIcon(m_hIcon, FALSE);        // Set small icon
    
    // TODO: Add extra initialization here
    InitialUserInterface();
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDFUDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
    if ((nID & 0xFFF0) == IDM_ABOUTBOX)
    {
        CAboutDlg dlgAbout;
        dlgAbout.DoModal();
    }
    else
    {
        CDialog::OnSysCommand(nID, lParam);
    }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDFUDlg::OnPaint() 
{
    if (IsIconic())
    {
        CPaintDC dc(this); // device context for painting

        SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

        // Center icon in client rectangle
        int cxIcon = GetSystemMetrics(SM_CXICON);
        int cyIcon = GetSystemMetrics(SM_CYICON);
        CRect rect;
        GetClientRect(&rect);
        int x = (rect.Width() - cxIcon + 1) / 2;
        int y = (rect.Height() - cyIcon + 1) / 2;

        // Draw the icon
        dc.DrawIcon(x, y, m_hIcon);
    }
    else
    {
        CDialog::OnPaint();
    }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDFUDlg::OnQueryDragIcon()
{
    return (HCURSOR) m_hIcon;
}

DWORD CDFUDlg::InitialUserInterface()
{
    DWORD dwResult = ERROR_SUCCESS;

	// Initial code buffer attributes
	m_edtCodeBuffer.SetAddressSize(6, FALSE);
	m_edtCodeBuffer.SetShowAddress(TRUE, FALSE);
	m_edtCodeBuffer.SetShowAscii(TRUE, FALSE);
	m_edtCodeBuffer.SetAdrCol(RGB(0xC8, 0xC8, 0xC8), RGB(0x00, 0x00, 0x00), FALSE);
	m_edtCodeBuffer.SetHexCol(RGB(0xC8, 0xC8, 0xC8), RGB(0x00, 0x00, 0x00), FALSE);
	m_edtCodeBuffer.SetAsciiCol(RGB(0xC8, 0xC8, 0xC8), RGB(0x00, 0x00, 0x00), FALSE);
	m_edtCodeBuffer.SetBytesPerRow(16, FALSE);
	m_edtCodeBuffer.SetNotUsedCol(RGB(0xC8, 0xC8, 0xC8));
	m_edtCodeBuffer.SetReadonly(TRUE);
	m_edtCodeBuffer.SetFont(GetFont());
        
    SetWindowText(g_szAppTitle); 
    dwResult = CreateStatusBar();
    m_edtVID.LimitText(4);
    m_cboPID.LimitText(4);

    dwResult = CheckNecessaryFile();
    if (dwResult == ERROR_SUCCESS)
    {
        m_edtVID.SetWindowText(g_Profile.GetVendorID());
        _tcscpy(m_tchPreVID, g_Profile.GetVendorID());        
    }

    UpdatePIDList();
    UpdateComboBoxFilePath();
 
    if (g_Profile.IsInitialLoad())
    {
        CheckDlgButton(IDC_CHECK_INITIAL_LOAD, TRUE);
        OnSelchangeComboFilePath();
    }
    if (g_Profile.IsAutoReload())
    {
        CheckDlgButton(IDC_CHECK_AUTO_RELOAD, TRUE);       
    }
    pDFU_Initialize();
    return dwResult;
}

DWORD CDFUDlg::CreateStatusBar()
{
    DWORD dwResult = ERROR_SUCCESS;
    TCHAR tchBuffer[0x40];

    m_StatusBar.Create(this);                  // Create the status bar
    m_StatusBar.SetIndicators(Indicators, 2);  // Set the number of panes
    
    CRect rect;
    GetClientRect(&rect);
    // ]wAC쪺e
    m_StatusBar.SetPaneInfo(0, ID_INDICATOR_MESSAGE, SBPS_NORMAL, rect.Width() - 90);
    m_StatusBar.SetPaneInfo(1, ID_INDICATOR_AP_VERSION, SBPS_STRETCH, 0);
    // ]wAC
    m_StatusBar.GetStatusBarCtrl().SetMinHeight(0x1A);

    //m_StatusBar.RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, ID_INDICATOR_FW_VERSION);
    RepositionBars(AFX_IDW_CONTROLBAR_FIRST, AFX_IDW_CONTROLBAR_LAST, ID_INDICATOR_AP_VERSION);

    dwResult = GetCurrentVersionInfo(&ApVersionInfo);
    if (dwResult == ERROR_SUCCESS)
        _stprintf(tchBuffer, _T("  v%d.%d.%d.%d"), ApVersionInfo.dwMajorVersion, ApVersionInfo.dwMinorVersion, ApVersionInfo.dwPatchVersion, ApVersionInfo.dwCustomVersion);
            
    // ]wACܪr
    m_StatusBar.SetPaneText(0, _T(""));     
    m_StatusBar.SetPaneText(1, tchBuffer);  
    //m_StatusBar.SetPaneText(2, _T("FW Version : 0x0100"));    
    return dwResult;
}

DWORD CDFUDlg::UpdatePIDList()
{
    DWORD dwResult = ERROR_SUCCESS;
    TCHAR szPID[0x05] = {0};
    TCHAR szVID[0x05] = {0};
    WORD wVID = 0;
    int intPIDIndex = CB_ERR;
        
    m_edtVID.GetWindowText(szVID, 0x05); 
    wVID = static_cast<WORD>(_tcstoul(szVID, NULL, 16));

    m_cboPID.GetLBText(m_cboPID.GetCurSel(), szPID);
    m_cboPID.ResetContent();
    EnumHidDevice(wVID, &m_cboPID);
    if (m_cboPID.GetCount() > 0)
    {
        intPIDIndex = m_cboPID.SelectString(0, szPID);
        if (intPIDIndex == CB_ERR)
            m_cboPID.SetCurSel(0);
    }
    else
    {
        m_cboPID.SetCurSel(-1);
    }
    return dwResult;
}

DWORD CDFUDlg::CheckNecessaryFile()
{
    TCHAR szProfilePath[MAX_PATH] = {0};
    TCHAR szDllPath[MAX_PATH] = {0};
    BOOL bResult = TRUE;
    DWORD dwResult = ERROR_SUCCESS;
    
    dwResult = GetAppFilePath(g_szAppPath, MAX_PATH);

    _stprintf(szProfilePath, _T("%s%s"), g_szAppPath, AfxGetApp()->m_pszProfileName);     

    dwResult = g_Profile.Load(szProfilePath);
    if (dwResult == ERROR_FILE_NOT_FOUND)
    {
        g_Profile.WriteToFile();
        dwResult = ERROR_SUCCESS;
    }
 
    _stprintf(szDllPath, _T("%s%s"), g_szAppPath, g_szDfuDllName);
    if (IsFileExist(szDllPath) == FALSE)
        dwResult = ExtractResourceToFile(AfxGetApp()->m_hInstance, _T("DLL"), IDR_DFU_DLL, szDllPath);

    if (dwResult == ERROR_SUCCESS)
    {
        g_hDfuDll = LoadLibrary(szDllPath);                          
        if (g_hDfuDll != NULL)
        {
            SetLastError(ERROR_SUCCESS);
            pDFU_ResetToISP = (MW_DFU_ResetToISP)GetProcAddress(g_hDfuDll, "DFU_ResetToISP");
            if (pDFU_ResetToISP != NULL)
            {
               pDFU_ResetToAP = (MW_DFU_ResetToAP)GetProcAddress(g_hDfuDll, "DFU_ResetToAP");
               if (pDFU_ResetToAP != NULL)
               {
                   pDFU_Download = (MW_DFU_Download)GetProcAddress(g_hDfuDll, "DFU_Download");
                   if (pDFU_Download != NULL)
                   {
                       pDFU_GetPercentage = (MW_DFU_GetPercentage)GetProcAddress(g_hDfuDll, "DFU_GetPercentage");  
                       if (pDFU_GetPercentage != NULL)
                       {
                            pDFU_Initialize = (MW_DFU_Initialize)GetProcAddress(g_hDfuDll, "DFU_Initialize");
                            if (pDFU_Initialize != NULL)
                                pDFU_Deinitialize = (MW_DFU_Deinitialize)GetProcAddress(g_hDfuDll, "DFU_Deinitialize");
                       }
                   }                
               }
            }
        }
        dwResult = GetLastError();
        if (dwResult != ERROR_SUCCESS)
            ShowErrorMessage(NULL, g_szAppTitle, dwResult, _T("oDLL禡Х!"));
    }
    else
        ShowErrorMessage(NULL, g_szAppTitle, dwResult, NULL);

    return dwResult;
}

void CDFUDlg::OnDropdownComboPid() 
{
	UpdatePIDList();
}

void CDFUDlg::OnButtonLoadFile() 
{
    int iCount = 0, i = 0;
    DWORD dwResult = ERROR_SUCCESS;
	TCHAR szFilePath[MAX_PATH] = {0};
    TCHAR szTemp[MAX_PATH];

	SelectFilePath(szFilePath);             // ϥΪ̶iɮ
	if (_tcslen(szFilePath) != 0)
	{
        dwResult = LoadFile(szFilePath);
        if (dwResult == ERROR_SUCCESS)
        {            
            GetFileLastWriteTime(&g_DownloadFile);

            _stprintf(szTemp, _T("%04X"), g_DownloadFile.m_dwFileSize);
            SetDlgItemText(IDC_STATIC_CODE_SIZE, szTemp);

            _stprintf(szTemp, _T("%04X"), static_cast<WORD>(g_DownloadFile.m_dwChecksum));
            SetDlgItemText(IDC_STATIC_CHECKSUM, szTemp);

            _stprintf(szTemp, _T("%02d/%02d/%02d %02d:%02d:%02d"), g_DownloadFile.m_LastWriteTime.wYear,
                                                                   g_DownloadFile.m_LastWriteTime.wMonth, 
                                                                   g_DownloadFile.m_LastWriteTime.wDay, 
                                                                   g_DownloadFile.m_LastWriteTime.wHour, 
                                                                   g_DownloadFile.m_LastWriteTime.wMinute, 
                                                                   g_DownloadFile.m_LastWriteTime.wSecond);
            SetDlgItemText(IDC_STATIC_LAST_MODIFY_TIME, szTemp);

            m_edtCodeBuffer.SetData(g_DownloadFile.m_pBuffer, g_DownloadFile.m_dwFileSize);

    	    g_Profile.AddToMRUList(szFilePath); // [JProfileMRUList
	    	UpdateComboBoxFilePath();           // sComboBox FilePathListItem         
        }		
        if (g_Profile.IsAutoReload())
        {
            SetupWatchThead(FALSE);
            SetupWatchThead(TRUE);
        }
	}	
}

void CDFUDlg::OnSelchangeComboFilePath() 
{
	// TODO: Add your control notification handler code here
    TCHAR szFilePath[MAX_PATH] = {0};
    int iResult;
    BOOL bExist = FALSE;
    BOOL bResult = FALSE;
    DWORD dwResult = ERROR_SUCCESS;
    TCHAR szTemp[MAX_PATH];

	iResult = m_cboFilePath.GetLBText(m_cboFilePath.GetCurSel(), szFilePath);
    bExist = IsFileExist(szFilePath);
    if (bExist == TRUE)
    {
        dwResult = LoadFile(szFilePath);
        if (dwResult == ERROR_SUCCESS)
        {            
            GetFileLastWriteTime(&g_DownloadFile);

            _stprintf(szTemp, _T("%04X"), g_DownloadFile.m_dwFileSize);
            SetDlgItemText(IDC_STATIC_CODE_SIZE, szTemp);

            _stprintf(szTemp, _T("%04X"), static_cast<WORD>(g_DownloadFile.m_dwChecksum));
            SetDlgItemText(IDC_STATIC_CHECKSUM, szTemp);

            _stprintf(szTemp, _T("%02d/%02d/%02d %02d:%02d:%02d"), g_DownloadFile.m_LastWriteTime.wYear,
                                                                   g_DownloadFile.m_LastWriteTime.wMonth, 
                                                                   g_DownloadFile.m_LastWriteTime.wDay, 
                                                                   g_DownloadFile.m_LastWriteTime.wHour, 
                                                                   g_DownloadFile.m_LastWriteTime.wMinute, 
                                                                   g_DownloadFile.m_LastWriteTime.wSecond);
            SetDlgItemText(IDC_STATIC_LAST_MODIFY_TIME, szTemp);

            m_edtCodeBuffer.SetData(g_DownloadFile.m_pBuffer, g_DownloadFile.m_dwFileSize);

            g_Profile.AddToMRUList(szFilePath);
            UpdateComboBoxFilePath(); 
            if (g_Profile.IsAutoReload())
            {
                SetupWatchThead(FALSE);
                SetupWatchThead(TRUE);
            }
        }
    }     
    else
    {
        dwResult = ERROR_FILE_NOT_FOUND;
        ShowErrorMessage(this->m_hWnd, g_szAppTitle, dwResult, NULL);
    }
}

DWORD CDFUDlg::UpdateComboBoxFilePath()
{
	DWORD dwResult = ERROR_SUCCESS;
	int iCount = 0;
	
	m_cboFilePath.ResetContent();
	iCount = g_Profile.GetMRUListCount();
	for(int i=0 ; i<iCount ; i++)
	    m_cboFilePath.AddString(g_Profile.GetMRUListItem(i));

    m_cboFilePath.SetCurSel(0);

	return dwResult;
}

BOOL CDFUDlg::DestroyWindow() 
{	
    g_Profile.WriteToFile();

    pDFU_Deinitialize();

	if (g_hDfuDll != NULL)
        FreeLibrary(g_hDfuDll);

    if (g_DownloadFile.m_pBuffer != NULL)
        delete []g_DownloadFile.m_pBuffer;

	return CDialog::DestroyWindow();
}

void CDFUDlg::OnCheckInitialLoad() 
{
    if (IsDlgButtonChecked(IDC_CHECK_INITIAL_LOAD) == BST_CHECKED)
        g_Profile.SetInitialLoad(TRUE);
	else
        g_Profile.SetInitialLoad(FALSE);
}

void CDFUDlg::OnCheckAutoReload() 
{
    if (IsDlgButtonChecked(IDC_CHECK_AUTO_RELOAD) == BST_CHECKED)
    {
        g_Profile.SetAutoReload(TRUE);
        SetupWatchThead(TRUE);
    }
	else
    {
        g_Profile.SetAutoReload(FALSE);
        SetupWatchThead(FALSE);
    }    
}

void CDFUDlg::OnButtonExit() 
{
	OnOK();
}

void CDFUDlg::OnButtonUpdate() 
{
    CString strTmp;		
	int CurValue = 0xFF;
	DWORD ExitCode;
    
	if (g_bInProcess == TRUE)
		return;

	g_NewFont.CreateFont(10,                        // nHeight
				  	     0,                         // nWidth
				 	     0,                         // nEscapement
					     0,                         // nOrientation
					     FW_NORMAL,                 // nWeight
					     FALSE,                     // bItalic
					     FALSE,                     // bUnderline
					     0,                         // cStrikeOut
					     ANSI_CHARSET,              // nCharSet
					     OUT_DEFAULT_PRECIS,        // nOutPrecision
					     CLIP_DEFAULT_PRECIS,       // nClipPrecision
					     DEFAULT_QUALITY,           // nQuality
					     DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
					     _T("Courier"));            // lpszFacename

    m_edtVID.GetWindowText(strTmp);
	_stscanf(strTmp, _T("%x"), &(g_ThreadInfo.Vid));
    m_cboPID.GetWindowText(strTmp);
	_stscanf(strTmp, _T("%x"), &(g_ThreadInfo.Pid));
    g_ThreadInfo.Checksum = g_DownloadFile.m_dwChecksum;    
	g_ThreadInfo.CodeSize = g_DownloadFile.m_dwFileSize;
    g_ThreadInfo.pDownloadBuffer = g_DownloadFile.m_pBuffer;

    if (g_ThreadInfo.CodeSize == 0)
	{
		MessageBox(_T("Buffer size is zero !"));
	    return;
	}

	hDownloadThread = _beginthreadex(NULL,                           // no security attributes 
			 						 0,                              // use default stack size  
									 DownloadThread,                // thread function 
									 &g_ThreadInfo,                    // argument to thread function 
									 CREATE_SUSPENDED,               // use default creation flags 
									 &uiDownloadThreadId);           // returns the thread identifier 

	if (MessageBox(_T("Upgrade Firmware ?"), _T("Confirm File"), MB_ICONQUESTION | MB_YESNO) == IDYES)
    {
		ShowPercentage(_T("Searching device..."), -1);			
		g_bInProcess = TRUE;        
        ResumeThread((void*)hDownloadThread);
	}
	else
	{		
		ResumeThread((void*)hDownloadThread);
		CloseHandle((void*)hDownloadThread);
        g_NewFont.DeleteObject();		
		return;
    }
    while(g_bInProcess == TRUE)	
	{
	    if (g_bInDownload == TRUE)
		{
		    CurValue = pDFU_GetPercentage();
			if (0xFF != CurValue)
			{
                ShowPercentage(NULL, CurValue);				
			}				
			Sleep(20);
		}
		
		MSG msg;
		while (::PeekMessage(&msg,NULL, 0, 0,PM_NOREMOVE))
		{
	        if (!AfxGetApp()->PumpMessage())
			{
			    ::PostQuitMessage(0);	
				break;		
			}
		}
	}
    CurValue = pDFU_GetPercentage();	    
    ShowPercentage(NULL, CurValue);	       		
	WaitForSingleObject((void*)hDownloadThread, INFINITE);
    ShowPercentage(NULL, -1);
	GetExitCodeThread((void*)hDownloadThread, &ExitCode);
	switch (ExitCode)
	{
	case UPGRADE_SUCCESSFULLY : 
	     MessageBox(_T("Upgrade successfully !"), _T("Upgrade Firmware"), MB_OK | MB_ICONINFORMATION);
	     break;
    case DFU_RESET_TO_AP_FAIL: 
	     MessageBox(_T("DFU_Reset_To_AP fail !"), _T("Upgrade Firmware"), MB_OK | MB_ICONWARNING);
	     break;
	case DFU_DOWNLOAD_FAIL: 
	     MessageBox(_T("DFU_Download fail !"), _T("Upgrade Firmware"), MB_OK | MB_ICONERROR);	
	     break;
	case DFU_RESET_TO_ISP_FAIL: 
	     MessageBox(_T("DFU_Reset_To_ISP fail !"), _T("Upgrade Firmware"), MB_OK | MB_ICONERROR);	
	     break;	
	}
    g_NewFont.DeleteObject();		
	CloseHandle((void*)hDownloadThread);	
}

DWORD CDFUDlg::SetupWatchThead(BOOL bRun)
{
	DWORD dwResult = ERROR_SUCCESS;
    if (bRun == FALSE)  // unثebANn
    {
	    if (hWatchThread != NULL)
	    {		
		    g_bStopWatchThread = TRUE;
		    DWORD dwResult  = WaitForSingleObject((void*)hWatchThread,5000);	
		    CloseHandle((void*)hWatchThread);
		    hWatchThread = NULL;
		    dwResult = ERROR_SUCCESS;            
	    }
        return dwResult;
    }
    else  // pGAutoReloadQĿAhsإ߰
    {
        if ((g_Profile.IsAutoReload() == TRUE) && (m_cboFilePath.GetCurSel() != CB_ERR))
	    {
            if (IsFileExist(g_DownloadFile.m_szFilePathName) == TRUE)
     	    {
			    hWatchThread = _beginthreadex(NULL,                  // no security attributes 
		 	 	    						  0,                     // use default stack size  
					    					  WatchThread,           // thread function 
						    				  GetSafeHwnd(),         // argument to thread function 
							    			  0,                     // use default creation flags 
								    		  &uiDownloadThreadId);  // returns the thread identifier          	
		    }
        }
    }
	return dwResult;
}

BOOL CDFUDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_ESCAPE)  
    {
        return TRUE;  
    } 
    else
	    return CDialog::PreTranslateMessage(pMsg);
}

LRESULT CDFUDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{    
	if (message == MW_CHANGE_NOTIFICATION)
    {
        TCHAR szTempFilePath[MAX_PATH] = {0};
	    DWORD dwResult = ERROR_SUCCESS;
        TCHAR szTemp[MAX_PATH];
        _tcscpy(szTempFilePath, g_DownloadFile.m_szFilePathName);
                
        dwResult = LoadFile(szTempFilePath);
        if (dwResult == ERROR_SUCCESS)
        {            
            GetFileLastWriteTime(&g_DownloadFile);

            _stprintf(szTemp, _T("%04X"), g_DownloadFile.m_dwFileSize);
            SetDlgItemText(IDC_STATIC_CODE_SIZE, szTemp);

            _stprintf(szTemp, _T("%04X"), static_cast<WORD>(g_DownloadFile.m_dwChecksum));
            SetDlgItemText(IDC_STATIC_CHECKSUM, szTemp);

            _stprintf(szTemp, _T("%02d/%02d/%02d %02d:%02d:%02d"), g_DownloadFile.m_LastWriteTime.wYear,
                                                                   g_DownloadFile.m_LastWriteTime.wMonth, 
                                                                   g_DownloadFile.m_LastWriteTime.wDay, 
                                                                   g_DownloadFile.m_LastWriteTime.wHour, 
                                                                   g_DownloadFile.m_LastWriteTime.wMinute, 
                                                                   g_DownloadFile.m_LastWriteTime.wSecond);
            SetDlgItemText(IDC_STATIC_LAST_MODIFY_TIME, szTemp);

            m_edtCodeBuffer.SetData(g_DownloadFile.m_pBuffer, g_DownloadFile.m_dwFileSize);
        }
        return 0;
    }
    else
	    return CDialog::WindowProc(message, wParam, lParam);
}

//-----------------------------------------------------------------------------
// Function Name : ShowPercentage
// Input         : pBuffer
//                 Percentage
// Return        : 
//-----------------------------------------------------------------------------
// Description   : Display the progress bar with specified string and percentage
//                 
//-----------------------------------------------------------------------------
void CDFUDlg::ShowPercentage(TCHAR *pBuffer, int Percentage)
{
	CDC * pDC;
	CRect ClientRect, LeftRect, RightRect;
    CFont * pOldFont = NULL;
	COLORREF fontColor;
		
	pDC = m_prgPercentage.GetDC();
	pOldFont = pDC->SelectObject(&g_NewFont);
	m_prgPercentage.GetClientRect(&ClientRect);

	LeftRect = RightRect = ClientRect;
	LeftRect.right = LeftRect.left + (int)((ClientRect.right - ClientRect.left) * Percentage / 100);		
	RightRect.left = LeftRect.right;

	pDC->FillSolidRect(RightRect, GetSysColor(COLOR_BTNFACE));	
	
	CString str;
	if ((Percentage >= 0) && (Percentage <= 100))
	{
        //OutputDebugString("AAA");
		m_prgPercentage.SetPos(Percentage);        
        if (pBuffer == NULL)
        {
            if (Percentage == 100)         
		        str.Format(_T("Completed ...%d%%"), Percentage);
            else
                str.Format(_T("Download ...%d%%"), Percentage);
        }
        else
             str.Format(_T("%s ...%d%%"), pBuffer, Percentage);
		fontColor = RGB(0xFF,0xFF,0xFF);
	}
	else
	{
        m_prgPercentage.SetPos(0);
        if (pBuffer != NULL)
            str.Format(_T("%s"), pBuffer);        
        else 
            str = _T("");
		fontColor = RGB(0,0,0);
    }
	pDC->SetBkMode(TRANSPARENT);

	CRgn rgn;

	rgn.CreateRectRgn(LeftRect.left, LeftRect.top, LeftRect.right, LeftRect.bottom);
	pDC->SelectClipRgn(&rgn);
	pDC->SetTextColor(fontColor);	            
	pDC->ExtTextOut(180, 5, ETO_CLIPPED, &LeftRect, str, NULL);
	rgn.DeleteObject();

	rgn.CreateRectRgn(RightRect.left, RightRect.top, RightRect.right, RightRect.bottom);
	pDC->SelectClipRgn(&rgn);
	pDC->SetTextColor(RGB(0x0A, 0x34, 0x6A));        
	pDC->ExtTextOut(180, 5, ETO_CLIPPED, &RightRect, str, NULL);
	rgn.DeleteObject();

	pDC->SelectObject(pOldFont);	
				
	m_prgPercentage.ReleaseDC(pDC);	
}

void CDFUDlg::OnDropFiles(HDROP hDropInfo)
{
    HDROP hFilesInfo;                  // Handle to file info structure when files
                                       // are dropped on our application
    WORD wTotalFiles;                  // Number of files dropped on our application
    WORD wIndex;                       // Counter of files
    TCHAR szFileName[MAX_PATH];        // Buffer for filename
	// TODO: Add your message handler code here and/or call default
    hFilesInfo = (HDROP)hDropInfo;

    // get number of files dropped
    wTotalFiles = DragQueryFile(hFilesInfo, -1, NULL, 0);

    // limit the number of files
    wTotalFiles = 1;
    // add the file names to the listbox
    for (wIndex = 0; wIndex < wTotalFiles; wIndex++)
    {
        // get the next file name
        DragQueryFile(hFilesInfo, wIndex, (LPTSTR)szFileName, MAX_PATH);

        // add the file name to the ComboBox and MRU List        
        g_Profile.AddToMRUList(szFileName);
	   	UpdateComboBoxFilePath();           // sComboBox FilePathListItem         
        		
        if (g_Profile.IsAutoReload())
        {
            SetupWatchThead(FALSE);
            SetupWatchThead(TRUE);
        }
    }
    // release memory Windows allocated for transferring 
    // filenames to app
    DragFinish(hFilesInfo);  	

	OnSelchangeComboFilePath();
}

void CDFUDlg::OnChangeEditVid() 
{    
    TCHAR tchVID[0x05] = {0};
	if (m_edtVID.LineLength() == 4)
	{		
        m_edtVID.GetWindowText(tchVID, 5);
		if (_tcscmp(tchVID, m_tchPreVID) != 0)
		{
			UpdatePIDList();
			g_Profile.SetVendorID(tchVID);
			_tcscpy(m_tchPreVID, tchVID);
		}
	}	
}
