// Profile.cpp: implementation of the CProfile class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Profile.h"
#include "GenericFunc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


const int MAX_MRULIST = 10;
const TCHAR tchDefaultVendorID[] = _T("0E6A");

const TCHAR KEY_AUTO_RELOAD[] = _T("AutoReload");
const TCHAR KEY_INITIAL_LOAD[] = _T("InitialLoad");
const TCHAR KEY_VENDOR_ID[] = _T("VendorID");
const TCHAR KEY_PREFIX[] = _T("File");

const TCHAR SECTION_MRU_LIST[] = _T("MRUList");
const TCHAR SECTION_CONFIGURATION[] = _T("Configuration");

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CProfile::CProfile()
{
    m_bAutoReload = FALSE;
    m_bInitialLoad = FALSE;
    _tcscpy(m_tchVendorID, tchDefaultVendorID);
    memset(m_tchProfilePathName, 0, MAX_PATH * sizeof(TCHAR));    
}

CProfile::~CProfile()
{    
    m_MRUList.RemoveAll();
}

DWORD CProfile::RemoveFromMRUList(LPCTSTR lpFilePathName)
{
    DWORD dwResult = ERROR_SUCCESS;
    POSITION pos = NULL;
    TCHAR tchTempBuffer[MAX_PATH] = {0};
    int i = 0;

    pos = m_MRUList.Find(lpFilePathName);
    if (pos != NULL)
        m_MRUList.RemoveAt(pos);

    for (i = 1,pos = m_MRUList.GetHeadPosition(); pos != NULL; i++)
    {
        _stprintf(tchTempBuffer, _T("%s%d"), KEY_PREFIX, i);
        WritePrivateProfileString(SECTION_MRU_LIST, tchTempBuffer, m_MRUList.GetNext(pos), m_tchProfilePathName);         
    }
    for ( ; i < MAX_MRULIST; i++)
    {
        _stprintf(tchTempBuffer, _T("%s%d"), KEY_PREFIX, i);
        WritePrivateProfileString(SECTION_MRU_LIST, tchTempBuffer, NULL, m_tchProfilePathName);
    }

    return dwResult;
}

LPCTSTR CProfile::GetMRUListItem(int Index)
{
    POSITION pos = NULL;

    pos = m_MRUList.FindIndex(Index);
    if (pos != NULL)
        return m_MRUList.GetAt(pos);
   
    return NULL;
}

DWORD CProfile::AddToMRUList(LPCTSTR lpFilePathName)
{
    DWORD dwResult = ERROR_SUCCESS;
    POSITION pos = NULL;
    TCHAR tempBuffer[MAX_PATH] = {0};
    int i = 0;

    if (lpFilePathName != NULL)
    {
        pos = m_MRUList.Find(lpFilePathName);
        if (pos == NULL)
        {
            if (m_MRUList.GetCount() >= MAX_MRULIST)
                m_MRUList.RemoveTail();            
            m_MRUList.AddHead(lpFilePathName);
        }
        else
        {
            m_MRUList.RemoveAt(pos);
            m_MRUList.AddHead(lpFilePathName);
        }
    }

    return dwResult;
}

DWORD CProfile::Load(LPCTSTR lpFilePathName)
{
    DWORD dwResult = ERROR_SUCCESS;
    BOOL bResult = FALSE;
    TCHAR tchKey[MAX_PATH] = {0};
    TCHAR tchFilePath[MAX_PATH] = {0};
    int i = 0;

    _tcscpy(m_tchProfilePathName, lpFilePathName);
    bResult = IsFileExist(lpFilePathName);
    if (bResult == TRUE)
    {        
        _tcscpy(m_tchProfilePathName, lpFilePathName);
        dwResult = GetPrivateProfileString(SECTION_CONFIGURATION, KEY_VENDOR_ID, _T("0E6A"), m_tchVendorID, 5, lpFilePathName);
        
        m_bAutoReload = GetPrivateProfileInt(SECTION_CONFIGURATION, KEY_AUTO_RELOAD, FALSE, lpFilePathName);    
        m_bInitialLoad = GetPrivateProfileInt(SECTION_CONFIGURATION, KEY_INITIAL_LOAD, FALSE, lpFilePathName);          
        
        for (i = 0; i < MAX_MRULIST; i++)
        {
            _stprintf(tchKey, _T("%s%d"), KEY_PREFIX, i);
            dwResult = GetPrivateProfileString(SECTION_MRU_LIST, tchKey, _T(""), tchFilePath, MAX_PATH-1, lpFilePathName);
            if (dwResult == 0)
            {
                break;
            }
            else
            {
                m_MRUList.AddTail(tchFilePath);
                dwResult = 0;
            }
        }
    }
    else
    {
        dwResult = ERROR_FILE_NOT_FOUND;
    }
    return dwResult;
}

void CProfile::SetVendorID(WORD wVID)
{
    _stprintf(m_tchVendorID, _T("%04X"), wVID);
}

void CProfile::SetVendorID(LPCTSTR pVID)
{
    DWORD dwTemp = 0;
    if (pVID != NULL)
    {
        dwTemp = _tcstoul(pVID, NULL , 16);
        if (dwTemp != 0)
        {
            if (_tcscmp(m_tchVendorID , pVID) != 0)             
            {
                _tcsncpy(m_tchVendorID, pVID, 4);
                m_tchVendorID[4] = '\0' ;
            }           
        }
    }
}

void CProfile::SetAutoReload(BOOL bNewValue)
{
    TCHAR tchTempBuffer[2] = {0};
    
    if (bNewValue != 0)
        m_bAutoReload = 1;
    else
        m_bAutoReload = 0;
}

void CProfile::SetInitialLoad(BOOL bNewValue)
{
    TCHAR tchTempBuffer[2] = {0};
    
    if (bNewValue != 0)
        m_bInitialLoad = 1;
    else
        m_bInitialLoad = 0;

}

BOOL CProfile::IsAutoReload()
{
    return m_bAutoReload;
}

BOOL CProfile::IsInitialLoad()
{
    return m_bInitialLoad;                                                                           
}

LPCTSTR CProfile::GetVendorID()
{
    return m_tchVendorID;
}

DWORD CProfile::WriteToFile()
{
    TCHAR tchTempBuffer[MAX_PATH] = {0};
    POSITION pos = NULL;
    BOOL bResult;
    DWORD dwResult = ERROR_SUCCESS;
    TCHAR tchKey[MAX_PATH] = {0};

    bResult = WritePrivateProfileString(SECTION_CONFIGURATION, KEY_VENDOR_ID, m_tchVendorID, m_tchProfilePathName);
    if (bResult == TRUE)
    {
        _stprintf(tchTempBuffer, _T("%u"), m_bAutoReload);
        bResult = WritePrivateProfileString(SECTION_CONFIGURATION, KEY_AUTO_RELOAD, tchTempBuffer, m_tchProfilePathName);
    }
  
    if (bResult == TRUE)
    {
        _stprintf(tchTempBuffer, _T("%u"), m_bInitialLoad);
        bResult = WritePrivateProfileString(SECTION_CONFIGURATION, KEY_INITIAL_LOAD, tchTempBuffer, m_tchProfilePathName);
    }
    
    for (int i = 0; i < m_MRUList.GetCount(); i++)
    {        
        _stprintf(tchKey, _T("%s%d"), KEY_PREFIX, i);
        pos = m_MRUList.FindIndex(i);
        bResult = WritePrivateProfileString(SECTION_MRU_LIST, tchKey, m_MRUList.GetAt(pos), m_tchProfilePathName);
    }
    if (bResult != TRUE)
        dwResult = GetLastError();

    return dwResult;
}

int CProfile::GetMRUListCount()
{
    return m_MRUList.GetCount();
}
