
#define		uCHAR	unsigned char
#define		BYTE	unsigned char
#define		uINT	unsigned int

#include "REG_MG82G5Exx.H"

#define		T2X12				0x10

#define		URTS				0x80
#define		SMOD2				0x40
#define		S1TR				0x10
#define		S1MOD				0x08
#define		S1X12				0x04
#define		MCKS1				0x08
#define		MCKS0				0x04

#define		AFS					0x80
#define		CKCON2				0x40

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

bit flag_Tx0_Busy;
uCHAR i;
uCHAR tmp;
uCHAR UID_Code[16];


void INT_UART0(void) interrupt 4
{
	if(RI0){
		RI0 = 0;
		
	}else if(TI0)
	{
		TI0 = 0;
		if(flag_Tx0_Busy == 1)
			flag_Tx0_Busy = 0;
	}
}


void Initial_UART0(void)		//MCU Run 11.0592MHz, Baud Rate is 9600bps.
{
	S0CON = 0x50;
	T2CON = 0x30;
	T2MOD = T2X12;
	RCAP2H = 0xFF;
	RCAP2L = 0xB8;				//if you want to change Baud Rate, you can refer to Table 17-16 right in Spec.
	TH2 = 0xFF;
	TL2 = 0xB8;
	TR2 = 1;
	PCON0 |= 0x80;						//SMOD1 = 1;
}

void UART0_Send_Byte(uCHAR dta)
{
	SFRPI = 0x00;
	S0BUF = dta;
	flag_Tx0_Busy = 1;
	while(flag_Tx0_Busy);
}

void UART0_Show_UID(void)
{
	ISPCR = ISP_ENABLE;
	BOREV = 0x22;
	IFMT = 0x06;
	IFADRH = 0x00;
	IFADRL = 0xF0;
	
	for(i = 0; i < 16; i ++)
	{
		SCMD = 0x46;
		SCMD = 0xB9;
		UID_Code[i] = IFD;
		UART0_Send_Byte(IFD);					//Get Unique ID
		IFADRL ++;
	}
	ISPCR = ISP_DISABLE;
}


void main(void)
{
	CKCON0 |= AFS;				//MCU Run 11.0592MHz,
	Initial_UART0();
	ES0 = 1;
	EA = 1;

	
	UART0_Show_UID();

	
	while(1);
}
