/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*Description:
*			ADC 10bit,  P33(AIN5) for input
*			ADC interrupt sample
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
//#define LED_G_0		P33
#define LED_G_1		P46

#define TEST_ADC_DATA_CNT		64
xdata WordTypeDef TestBuf[TEST_ADC_DATA_CNT];
u8 TestBufLen;

bit bAdcflag;

/***********************************************************************************
*Function:   void INT_ADC(void)
*Description:ADC Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_ADC(void) interrupt INT_VECTOR_ADC
{
	WordTypeDef wAdcValue;
	LED_R=~LED_R;
    wAdcValue.B.BHigh=ADCDH;
    wAdcValue.B.BLow=ADCDL;
 	ADCON0 = ADCON0&(~ADCI);		           		// clear flag
	ADCON0 = ADCON0|ADCS;							// set ADCS, Start ADC
	if(bAdcflag==FALSE)
	{
		TestBuf[TestBufLen].W=wAdcValue.W;
		TestBufLen++;
		if(TestBufLen>=TEST_ADC_DATA_CNT)
		{
			TM_DisableT0();
			bAdcflag=TRUE;
		}
	}
}

/*************************************************
*Function: char putchar (char c)   
*Description: send for printf
*Input:     char c
*Output:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*Function:     void DelayXus(u16 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitUart0_S0BRG(void)
*Description:   Initialize Uart0, The source of baud rate was S0BRG
*Input:   
*Output:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// Set SFR 0xB9 address to access S0CR1
	UART0_SetMode8bitUARTVar();			// 8-bit, Variable B.R.
	UART0_EnReception();				// Enable reception
	UART0_SetBRGFromS0BRG();			// B.R. source: S0BRG
	UART0_SetS0BRGBaudRateX2();			// S0BRG x2
	UART0_SetS0BRGSelSYSCLK();			// S0BRG clock source:SYSCLK
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);

	UART0_EnS0BRG();					// Enable S0BRG
}

/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2); 				// Set P30,P31,P32 as Quasi-Bidirectional,for RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);					// Set P46 as Open-Drain with pull-up resistor,for LED
	PORT_P33_EnAnalogOnly();  						// Set P33 as Analog-Input-Only for ADC input
}

/***********************************************************************************
*Function:   void InitTimer0(void)
*Description:Initialize Timer0	
*Input:   
*Output:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// TIMER0 Mode: 16-bit
	TM_SetT0Clock_SYSCLKDiv12();			// TIMER0 Clock source: SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(0);						// Set TL0 value
	TM_SetT0HighByte(0);					// Set TH0 value

	TM_DisableT0();							// Disable TIMER0
}

/***********************************************************************************
*Function:   void InitADC(void)
*Description:   Initialize ADC
*Input:   
*Output:     
*************************************************************************************/
void InitADC(void)
{
	ADC_Enable();						// Enable ADC
	ADC_SetClock_SYSCLKDiv2();			// ADC Clock = SYSCLK/2       sps= 8M/2/24=83.3k
	ADC_SetMode_SetADCS();				// ADC Trigger mode: set ADCS
	ADC_SetRightJustified();			// ADC Right-Jutified
	ADC_SetADCData_10Bit();				// ADC 10bit
	ADC_SetChannel_AIN5_P33();			// ADC Channel: AIN5(P33)
}

/***********************************************************************************
*Function:   void InitClock(void)
*Description:   Initialize clock	
*Input:   
*Output:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45 ouput MCK/4
	//CLK_P45OC_MCKDiv4();
}

/***********************************************************************************
*Function:   void InitInterrupt(void)
*Description:   Initialize Interrupt 
*Input:   
*Output:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnADC();					// Enable ADC interrupt
}	

/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitUart0_S0BRG();
	InitADC();
	InitTimer0();
	InitInterrupt();
}

void main()
{
	u8 i;
	u16 wAdcMIN,wAdcMAX,wAdcAVG;
	u32 dwTemp;
	WordTypeDef wAdcTime;
	
    InitSystem();
	
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;

	printf("\nHello..ADC INT");
	
	TestBufLen=0;
	TH0=0;
	TL0=0;
	TM_EnableT0();
	bAdcflag=FALSE;

	ADC_SoftStart();
	
	INT_EnAll();		
	
    while(1)
    {
    	LED_G_1=~LED_G_1;
		DelayXms(500);
		
		if(bAdcflag==TRUE)
		{
			wAdcTime.B.BHigh=TH0;
			wAdcTime.B.BLow=TL0;
			
			dwTemp=0;
			wAdcMIN=0xFFFF;
			wAdcMAX=0x0000;
			
			for(i=0;i<(TEST_ADC_DATA_CNT);i++)
			{
				dwTemp=dwTemp+TestBuf[i].W;
				if(wAdcMIN>=TestBuf[i].W)
				{
					wAdcMIN=TestBuf[i].W;
				}
				if(wAdcMAX<TestBuf[i].W)
				{
					wAdcMAX=TestBuf[i].W;
				}
				
			}
			wAdcAVG=dwTemp/TEST_ADC_DATA_CNT;		
			printf("\nADC INT ");
			printf("Sample cnt:%bd,",i);
			printf(" Total time:%dus,",wAdcTime.W);
			printf(" MIN:%04X,",wAdcMIN);
			printf(" MAX:%04X,",wAdcMAX);
			printf(" AVG:%04X",wAdcAVG);
			TestBufLen=0;
			TH0=0;
			TL0=0;
			TM_EnableT0();
			bAdcflag=FALSE;
		}
    }
}

