/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=16MHz
*Description:
*			CPUCLK=SYSCLK (16M)
*			PCA clock: SYSCLK
*			CH0(P30),CH1(P33),CH2(P31),CH3(P46)
*			Change duty in PCA interrupt
*			Edge aligned, Resolution is 1000
*			PWM freq: PCAClk/(1000)=16MHz/1000=16KHz
*
*			P10 as input to control PWM output.P10=1: Enable, P10=0: Disable
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define TIMER_12T_10ms_TH	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) /256) 			
#define TIMER_12T_10ms_TL	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46


#define PWM_MIN			(0*1)
#define PWM_MAX			(1000*1)
#define PWM_3_4			(750*1)
#define PWM_2_4			(500*1)
#define PWM_1_4			(250*1)
#define PWM_LOW			(40*1)
#define PWM_HINT		(50*1)

#define PCA_RELOAD		(PWM_MAX)

#define PCA_C           (65536)       	

#define PCA_CL(x)		(u8)((~(u16)x)+1) 
#define PCA_CH(x)     	(u8)(((~(u16)x)+1)>>8)         

idata WordTypeDef wDuty[4];
bit bDutyChange;
u8 DutyFlag;

/***********************************************************************************
*Function:   void INT_PCA(void)
*Description:PCA Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_PCA(void) interrupt INT_VECTOR_PCA
{
	WordTypeDef duty;
	_push_(SFRPI);
	SFRPI=0;
	if(CF)
	{
		LED_R=!LED_R;
		CF=0;
		// Todo...
		// ......
		if(bDutyChange)
		{
			duty.W=PCA_C-wDuty[0].W;
			PCA_CH0_SetValue(duty.B.BHigh,duty.B.BLow);
			duty.W=PCA_C-wDuty[1].W;
			PCA_CH1_SetValue(duty.B.BHigh,duty.B.BLow);
			duty.W=PCA_C-wDuty[2].W;
			PCA_CH2_SetValue(duty.B.BHigh,duty.B.BLow);
			duty.W=PCA_C-wDuty[3].W;
			PCA_CH3_SetValue(duty.B.BHigh,duty.B.BLow);
			bDutyChange=FALSE;
		}
	}
	_pop_(SFRPI);
}

/*************************************************
*Function:     void DelayXus(u8 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP4PushPull(BIT6);						// Set P46 as push-pull
	PORT_SetP3PushPull(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as push-pull

	P10=1;
	PORT_SetP1OpenDrainPu(BIT0);					// Set P10 as Open-Drain with pull-up resistor
}


/***********************************************************************************
*Function:   void InitPCA_PWM(void)
*Description:   Initialize PCA
*Input:   
*Output:     
*************************************************************************************/
void InitPCA_PWM(void)
{
	PCA_SetCLOCK_SYSCLK();							// PCA clock = SysClk
	
	PCA_CH0_SetMode_PWM();
	PCA_CH1_SetMode_PWM();
	PCA_CH2_SetMode_PWM();
	PCA_CH3_SetMode_PWM();

	PCA_CH0_SetPWM_16Bit();
	PCA_CH1_SetPWM_16Bit();
	PCA_CH2_SetPWM_16Bit();
	PCA_CH3_SetPWM_16Bit();


	PCA_SetPWM_EdgeAligned();						// Edge aligned

	// Set PWM duty
	PCA_CH0_SetValue(PCA_CH(PWM_MIN),PCA_CL(PWM_MIN));
	PCA_CH1_SetValue(PCA_CH(PWM_MIN),PCA_CL(PWM_MIN));
	PCA_CH2_SetValue(PCA_CH(PWM_MIN),PCA_CL(PWM_MIN));
	PCA_CH3_SetValue(PCA_CH(PWM_MIN),PCA_CL(PWM_MIN));

	// Set Freq
	PCA_SetCounter(PCA_C-PCA_RELOAD);
	PCA_SetCounterReload(PCA_C-PCA_RELOAD);

	// Disable PWM output
	PCA_SetPWM0_DisOutput();					
	PCA_SetPWM1_DisOutput();
	PCA_SetPWM2_DisOutput();					
	PCA_SetPWM3_DisOutput();

	PCA_SetCEX0CEX1CEX2CEX3_P30P33P31P46();			// Set CEX0/CEX1/CEX2/CEX3 pin: P30P33P31P46

	PCA_CF_EnInterrupt();							// Enable CF interrupt

	PCA_EnPCACounter();								// Enable PCA counter, 
}

/***********************************************************************************
*Function:   void InitInterrupt(void)
*Description:   Initialize Interrupt 
*Input:   
*Output:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnPCA();					// Enable PCA interrupt
}	

/***********************************************************************************
*Function:   void InitClock(void)
*Description:   Initialize clock	
*Input:   
*Output:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45 ouput MCK/4
	//CLK_P45OC_MCKDiv4();
}

/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitClock();
	InitPort();
	InitPCA_PWM();
	InitInterrupt();
}

void main()
{
	u8 i,x,cnt;
	bit bOutFlag;
    InitSystem();

	LED_G_0=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;

	INT_EnAll();

	wDuty[0].W=PWM_MIN;
	wDuty[1].W=PWM_LOW;
	wDuty[2].W=PWM_1_4;
	wDuty[3].W=PWM_2_4;
	
	DutyFlag=0x00;
	bOutFlag=FALSE;
	
	while(1)
    {
    	DelayXms(1);
    	cnt++;
    	if(cnt>=200)
    	{
			cnt=0;
	    	LED_R=!LED_R;
	    	if(bOutFlag==TRUE)
	    	{
				while(bDutyChange==TRUE);		// wait for the previous data is complete
		    	x=0x01;
		    	for(i=0;i<4;i++)
		    	{
					if((DutyFlag&x)==0)
					{
						wDuty[i].W=wDuty[i].W+20;
						if(wDuty[i].W >= PWM_MAX)
						{
							wDuty[i].W = PWM_MAX;
							DutyFlag=DutyFlag|x;
						}
					}
					else
					{
						if(wDuty[i].W < 21)
						{
							wDuty[i].W = PWM_MIN;
							DutyFlag=DutyFlag&(~x);
						}
						else
						{
							wDuty[i].W=wDuty[i].W-20;
						}
					}
					x=x<<1;
		    	}
		    	bDutyChange=TRUE;
	    	}
    	}
    	if(P10==1)
    	{
			if(bOutFlag==FALSE)
			{
				bOutFlag=TRUE;
				// Enable PWM output
				PCA_SetPWM0_EnOutput(); 				
				PCA_SetPWM1_EnOutput();
				PCA_SetPWM2_EnOutput(); 				
				PCA_SetPWM3_EnOutput();
			}
    	}
    	else
    	{
			if(bOutFlag==TRUE)
			{
				bOutFlag=FALSE;
				// Disable PWM output
				PCA_SetPWM0_DisOutput();					
				PCA_SetPWM1_DisOutput();
				PCA_SetPWM2_DisOutput();					
				PCA_SetPWM3_DisOutput();
			}
    	}
    }
}

