/*********************************************************************
    Project:MG82F6D17-DEMO
    Author:YZY
			MG82F6D17 SSOP20_V10 EV Board (TH194A)
			CpuCLK=24MHz, SysCLK=48MHz
	Description:
			Set P10,P11,P16 for INT1,INT0,INT2, falling edge trigger
			If 20s no interruption triggered, enter Power-Down mode
			INT0,INT1,INT2 wake up at Falling Edge
	Note:

    Creat time::
    Modify::
    
*********************************************************************/
#include "MG82F6D17_CONFIG.h"

#define MCU_SYSCLK		48000000
#define MCU_CPUCLK		24000000
#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35
#define ISP_WRITE_P     4     // P Write
#define ISP_READ_P     	5     // P Read
#define POW_SetMode_PD()			PCON0|=PD;
u8 WakeUpSorce;
u8 INTCnt;

/***********************************************************************************
Function:   	u8 IAP_ReadPPage(u8 PsfrAddr)
Description:	read P page sfr
Input:   
		 		u8 PsfrAddr: sfr Address
Output:     
		 		u8: sfr data
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					
	IFADRH = 0; 				// IFADRH must be 0
	IFADRL= PsfrAddr;			// sfr Address
	IFMT = ISP_READ_P;			// read P page sfr
	ISPCR = 0x80;				// Enable ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					// clear
	EA = bEA;					
	return IFD;					// return sfr data
}

/***********************************************************************************
Function:		void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
Description:	write P page sfr
Input:   
		 		u8 PsfrAddr: sfr Address
		 		u8 PsfrData: sfr data
Output:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//
	IFADRH = 0; 				// IFADRH must be 0
	IFADRL= PsfrAddr;			// sfr Address
	IFD= PsfrData;				// sfr data
	IFMT = ISP_WRITE_P;			// write P page sfr
	ISPCR = 0x80;				// Enable ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					// clear
	EA = bEA;					
}

/*************************************************
Function:     	void DelayXus(u16 xUs)
Description:   	dealyunit:us
Input:     			u8 Us -> *1us  (1~255)
Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
Function:     	void DelayXms(u16 xMs)
Description:    dealyunit:ms
Input:     			u16 xMs -> *1ms  (1~65535)
Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
	}
}

void main ()
{
	u8 BakCKCON2;						// Backup CKCON2 (if used PLL CKM)
  System_Init(); 
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

	INTCnt=0;
	WakeUpSorce=0;
	while(1)
	{

		if(WakeUpSorce == 0)
		{
			LED_G_0=!LED_G_0;
		}
		else if(WakeUpSorce == 1)
		{
			LED_R=!LED_R;
		}
		else
		{
			LED_G_1=!LED_G_1;
		}
		DelayXms(100);
		INTCnt++;
		if(INTCnt >=200)
		{
			LED_G_0=1;LED_G_1=1;LED_R=1;

			BakCKCON2=IAP_ReadPPage(CKCON2_P);							// Backup CKCON2 (if used PLL CKM)
			IAP_WritePPage(CKCON2_P,BakCKCON2&(~(MCKS0_P|MCKS1_P)));	// MCK=OSCin (if used PLL CKM)
			
			POW_SetMode_PD();											// MCU enter Power-Down mode
			
			_nop_();
			DelayXus(100);												// delay for stabilize CKM (if used PLL CKM)
			IAP_WritePPage(CKCON2_P,BakCKCON2); 						// restore CKCON2,use CKM (if used PLL CKM)
			

			__DRV_INT_ITEA_Cmd(DISABLE);						// Disable global interrupt	
			if(WakeUpSorce == 0)
			{
				LED_G_0=0;
			}
			else if(WakeUpSorce == 1)
			{
				LED_R=0;
			}
			else
			{
				LED_G_1=0;
			}
			DelayXms(1000);
			LED_G_0=1;LED_G_1=1;LED_R=1;
			__DRV_INT_ITEA_Cmd(ENABLE);						// Enable global interrupt	
			INTCnt=0;
		}

	}

}
