
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the DFU_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// DFU_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifndef DFUDLL_H_
#define DFUDLL_H_

#ifdef DFU_EXPORTS
#define DFU_API extern "C" __declspec(dllexport)
#else
#define DFU_API extern "C" __declspec(dllimport)
#endif

#define DEVICE_HAS_BEEN_IN_ISP           0xE0000100L
#define ANOTHER_DOWNLOAD_IS_RUNNING      0xE0000101L

DFU_API BOOL _stdcall DFU_ResetToISP(                     // Reset device to DFU mode
                                      DWORD VID ,         // Vender ID
                                      DWORD PID           // Product ID
                                     );
                            
DFU_API BOOL _stdcall DFU_ResetToAP(void);                // Reset device to AP mode

DFU_API BOOL _stdcall DFU_Download(                       // Download firmware to target
                                    BYTE *FW ,            // FW binary file 
                                    DWORD Addr ,          // Download start address
                                    DWORD Size ,          // FW file size
                                    DWORD CheckSum        // FW checksum
                                  );

DFU_API int   _stdcall DFU_Get_Percentage(void);          // Return percentage of upgrage process

DFU_API DWORD _stdcall DFU_Initialize(void);              // Create objects for download code

DFU_API DWORD _stdcall DFU_DeInitialize(void);            // Delete objects after download end.

typedef BOOL (_stdcall *MW_DFU_ResetToISP)   (DWORD VID, DWORD PID);
typedef BOOL (_stdcall *MW_DFU_ResetToAP)    (void);
typedef BOOL (_stdcall *MW_DFU_Download)     (BYTE *FW, DWORD Addr, DWORD Size, DWORD CheckSum);
typedef int  (_stdcall *MW_DFU_GetPercentage)(void);
typedef DWORD(_stdcall *MW_DFU_Initialize)   (void);
typedef DWORD(_stdcall *MW_DFU_Deinitialize) (void);

#endif