
#include "StdAfx.h"
#include "Enum.h"
#include <initguid.h>
#include <setupapi.h>
#include <dbt.h>
extern "C" {
    #include <hidsdi.h>
}

//-----------------------------------------------------------------------------
// Function Name : EnumHidDevice
// Input         : wdVID, the specified Verdor ID
//                 pComboBox, the control item to list all the Product ID
// Return        : dwResult
//-----------------------------------------------------------------------------
// Description   : 1. Enumerate all of the HID devices 
//                 2. Open every HID device and get HID attribute
//                 3. Compare with the specified Vendor ID
//                 4. List the Product ID in pComboBox
//-----------------------------------------------------------------------------
DWORD EnumHidDevice(WORD wdVID, CComboBox *pComboBox)
{
    DWORD dwResult = ERROR_SUCCESS;
    GUID HidGuid;
    HDEVINFO DevInfoSet;
    SP_DEVICE_INTERFACE_DATA DeviceInterfaceData;
    PSP_DEVICE_INTERFACE_DETAIL_DATA DetailData = NULL;
    BOOL bResult = FALSE;
    DWORD Index = 0;
    DWORD dwRequiredSize;
    DWORD dwDataSize;
    DWORD FindIndex = 0;
    HIDD_ATTRIBUTES HidAttrib;
    HANDLE DeviceHandle;
    CString strTmp;

    dwResult = CANNOT_FIND_THE_DEVICE_SPECIFIED;

    HidD_GetHidGuid(&HidGuid);

    DevInfoSet = SetupDiGetClassDevs(&HidGuid, NULL, NULL, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);
    
    if (DevInfoSet == INVALID_HANDLE_VALUE)
    {
        dwResult = ERROR_SUCCESS;
        return dwResult;
    }
    Index = 0;
    FindIndex = 0;

    DeviceInterfaceData.cbSize = sizeof(DeviceInterfaceData);
    do
    {  
        bResult = SetupDiEnumDeviceInterfaces(DevInfoSet, 0, &HidGuid, Index, &DeviceInterfaceData);
        if (bResult == TRUE)
        {     
            bResult = SetupDiGetDeviceInterfaceDetail(DevInfoSet, &DeviceInterfaceData, NULL, 0, &dwRequiredSize, NULL);            
            
            if (bResult == FALSE)
            {                
                dwResult = GetLastError();
                if (dwResult != ERROR_INSUFFICIENT_BUFFER)
                    break;
            }
            
            DetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(dwRequiredSize);
            dwDataSize = dwRequiredSize;            
            if (DetailData == NULL)
            {
                dwResult = INSUFFICIENT_MEMORY_AVAILABLE;
                break;
            } 
            DetailData->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
           
            bResult = SetupDiGetDeviceInterfaceDetail(DevInfoSet, &DeviceInterfaceData, DetailData, dwDataSize, &dwRequiredSize, NULL);
            if (bResult == FALSE)
            {
                dwResult = GetLastError();               
            }
            else
            {
                DeviceHandle = CreateFile(DetailData->DevicePath, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
                if (DeviceHandle == INVALID_HANDLE_VALUE)
                {
                    DeviceHandle = CreateFile(DetailData->DevicePath, 0, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
                }
                if (DeviceHandle != INVALID_HANDLE_VALUE)
                {
                    HidAttrib.Size = sizeof(HIDD_ATTRIBUTES);
                    bResult = HidD_GetAttributes(DeviceHandle, &HidAttrib);
                    if (bResult == TRUE)
                    {
                        if (HidAttrib.VendorID == wdVID)
                        {
                            strTmp.Format(_T("%04X"), HidAttrib.ProductID);
                            if (CB_ERR == pComboBox->FindString(0, strTmp))
                                pComboBox->AddString(strTmp);
                        }
                    }
                    else
                        dwResult = HIDD_GETATTRIBUTES_FAIL;

                    CloseHandle(DeviceHandle);
                }
            }

            free(DetailData);
            DetailData = NULL;

            Index++;
        }
    } while (bResult == TRUE);

    if (dwResult == ERROR_SUCCESS)
        dwResult = SetupDiDestroyDeviceInfoList(DevInfoSet);
    else
        SetupDiDestroyDeviceInfoList(DevInfoSet);

    return dwResult;
}