/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*Description:
*			RTC Clock source: ILRCO 32KHz
*			RTC Clock prescale: 32768
*			RTC Reload Value: (64-1)=63
*			RTC Overflow freq: 32000/32768/1 ~ 1Hz
*			Enter Power-Down mode, wake up by RTC
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46

#define IO_WAKE_KEY_0	P10
#define IO_WAKE_KEY_1	P30

u8 RtcCnt;

u8 WakeUpSorce;
enum{
	WAKE_BY_nINT0=0,
	WAKE_BY_nINT1,
	WAKE_BY_RTC,
};

/***********************************************************************************
*Function:   void INT_INT0(void)	
*Description:INT0Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_INT0(void)		interrupt INT_VECTOR_INT0
{
	WakeUpSorce=WAKE_BY_nINT0;
}

/***********************************************************************************
*Function:   void INT_INT1(void)	
*Description:INT1Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_INT1(void)		interrupt INT_VECTOR_INT1
{
	WakeUpSorce=WAKE_BY_nINT1;
}

/***********************************************************************************
*Function:   void INT_SF(void)
*Description:SF(System flag)Interrupt handler
		 RTC,WDTF,BOD0F,BOD1F
*Input:   
*Output:     
*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1&WDTF)!=0)
	{
		PCON1=WDTF;
	}
	if((PCON1&BOF0)!=0)
	{
		PCON1=BOF0;
	}
	if((PCON1&BOF1)!=0)
	{
		PCON1=BOF1;
	}
	if((PCON1&RTCF)!=0)
	{
		PCON1=RTCF;
		RtcCnt++;
		WakeUpSorce=WAKE_BY_RTC;
	}
}


/*************************************************
*Function:     void DelayXus(u8 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitINT0(void)
*Description:   Initialize INT0
*Input:   
*Output:     
*************************************************************************************/
void InitINT0(void)
{
	INT_SetINT0P30();						//nINT0:P30
	INT_SetINT0_DetectFallingEdge();		//nINT0 Detect: falling edge.On Power-Down mode,only Low Level.
	INT_SetINT0Filter_SysclkDiv6_x3();		//nINT0 filter: (sysclk/6)*3
}

/***********************************************************************************
*Function:   void InitINT1(void)
*Description:   Initialize INT1
*Input:   
*Output:     
*************************************************************************************/
void InitINT1(void)
{
	INT_SetINT1P10();						//nINT1:P10
	INT_SetINT1_DetectFallingEdge();		//nINT1 Detect: falling edge.On Power-Down mode,only Low Level.
	INT_SetINT1Filter_SysclkDiv6_x3();		//nINT1 filter: (sysclk/6)*3
}

/***********************************************************************************
*Function:   void InitRTC(void)
*Description:Initialize RTC	
*		RTC Clock source: ILRCO 32KHz
*		RTC Clock prescale: 32768
*		RTC Reload Value: (64-1)=63
*		RTC Overflow freq: 32K/32768/1~=1Hz
*Input:   
*Output:     
*************************************************************************************/
void InitRTC(void)
{	
	RTC_Disable();
	RTC_SetClock_ILRCO();		// RTC Clock source: ILRCO 32KHz
	RTC_SetClock_Div_32768();	// RTC Clock prescale: 32768
	RTC_SetReload(64-1);		// RTC Reload Value: (64-1)=63
	RTC_SetCounter(64-1);

	RTC_ClearRTCF();			// Clear RTCF
	RTC_Enable();				// Enable RTC
	
}


/***********************************************************************************
*Function:   void InitInterrupt(void)
*Description:Initialize Interrupt
*Input:   
*Output:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_RTC();			// Enable RTC interrupt, must enble SF interrupt
	INT_EnSF();				// Enable SF interrupt

	
}


/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as Quasi-Bidirectional,for RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				// Set P46 as Open-Drain with pull-up resistor,for LED
	PORT_SetP1OpenDrainPu(BIT0);				// Set P10,P11 as Open-Drain with pull-up resistor
	P10=1;
	P30=1;
}



/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitRTC();		
	InitINT0();
	InitINT1();
	InitInterrupt();		// Initialize Interrupt 
	INT_EnAll();			// Enable global interrupt

}

/***********************************************************************************
*Function:   void McuPowerDownProc(void)
*Description:  Mcu enter PD mode
*Input:   
*Output:     
*************************************************************************************/
void McuPowerDownProc(void)
{
	// wait wakeup pin is high
	while((IO_WAKE_KEY_0==0)||(IO_WAKE_KEY_1==0))
	{
		CLRWDT();
		DelayXus(100);
	}
	INT_EnINT0();							// Enable INT0 interrupt
	INT_EnINT1();							// Enable INT1 interrupt
	INT_EnAll();							// Enable global interrupt
PD_LOOP:
	POW_SetMode_PD();						// MCU enter PD mode
	// Wakeup, Will enter the interrupt processing and then return here
	_nop_();
	if(WakeUpSorce==WAKE_BY_RTC)
	{
		goto PD_LOOP;
	}
	else
	{
		INT_DisINT0();						//	Disable INT0 interrupt
		INT_DisINT1();						//	Disable INT1 interrupt
	}
}


void main()
{
	u8 i;
	
	
    InitSystem();
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
		LED_G_0=1;LED_G_1=1;LED_R=1;
		McuPowerDownProc();
		for(i=0;i<50;i++)
		{
			DelayXms(100);
			if(WakeUpSorce==WAKE_BY_nINT0)
			{
				LED_G_0=!LED_G_0;
			}
			else
			{
				LED_G_1=!LED_G_1;
			}
		}
    }
}

