/*********************************************************************
    Ŀ:MA82G5Cxx-DEMO
			԰ʹ MA82G5C64 LQFP64_V10	Ev Board (TH167A)
			CpuCLK=12MHz, SysCLK=12MHz
	  
			ȡ16ֽ UID, Գ
            ʹU1/U2 ѻ¼ϵк,жϸϵкǷȷķΧ
 	  ע

	  ʱ:
	  ޸־:
	  
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5Cxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5Cxx.H"
#include ".\include\API_Uart_BRGRL_MA82G5Cxx.H"


/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	33170000,36000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.25MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

#define ISP_ADDRESS    0xFE00	 //ISPʼַ 
#define IAP_ADDRESS    0xF600	 //IAPʼַ  

#define UID_ENCRYPT_BUF_ADDRESS	0x1000
#define DEVICE_SN_BUF_ADDRESS	0x0200


code u8 UIDEncryptBuf[16] _at_ UID_ENCRYPT_BUF_ADDRESS;

// ϵкţʹU1/U2 ѻ¼ϵкţʼַΪϵкűĵַ: 0x0200
// ϵк,ȷķΧ,¼ļ
code u8 DeviceSn[16] _at_ DEVICE_SN_BUF_ADDRESS;

// U1/U2 ѻ¼ϵкΪ12Ϊַ+4ֽ
// ж12λַǷǺ
code u8 DeviceSnString[]="Megawin--MCU";

/*************************************************
: char putchar (char c)   
: printf Ĵ
:     char c
:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}


/*************************************************
:     void DelayXus(u16 xUs)
:   		ʱ,λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
:        		
:
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}


/*************************************************
:     void DelayXms(u16 xMs)
:   		ʱ,λΪms
ú:        
:     u16 xMs -> *1ms  (1~65535)
:     
:        		
:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;

	}
}

/***********************************************************************************
:   void InitUart0_S1BRG(void)
:   Uartʼ
		  S1BRGΪԴ
:   
ز:     
*************************************************************************************/
void InitUart0_S1BRG(void)
{
	// 8λ ɱ䲨
	UART0_SetMode8bitUARTVar();

	// òԴΪ T1
	UART0_SetBRGFromS1BRG();
	// 4x
	UART0_SetS1BRGBaudRateX4();

	UART1_SetS1BRGSelSYSCLK();
	UART1_SetS1BRGValue(S1BRG_BRGRL_115200_4X_12000000_1T);
	UART1_EnS1BRG();	
}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);					// P55,P56,P57Ϊ(LED)
}



/******************************************************************************
*****
:   void InitClock(void)
:   ϵͳʱӳʼ
:   
ز:     
*******************************************************************************
******/
void InitClock()
{
	
#if (MCU_CPUCLK>=24000000)
	CLK_SetCpuCLK_HighSpeed();
#endif		


#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}


/***********************************************************************************
:   u8 IAP_ReadPPage(u8 PsfrAddr)
:ȡPҳ⹦
:   
		 u8 PsfrAddr: Pҳַ
ز:     
		 u8: Pҳ
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
	return IFD;
}



/***********************************************************************************
:void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
:дPҳ⹦
:   
		 u8 PsfrAddr: Pҳַ,u8 PsfrData:  Pҳ
ز:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}


/***********************************************************************************
:u8 IAP_ReadByte(u16 ByteAddr)
:ַָIAP
:   
		 u16 ByteAddr: IAPַ
ز:     
*************************************************************************************/
u8 IAP_ReadByte(u16 ByteAddr)
{
		bit bEA=EA;
		IFADRH = ByteAddr>>8;		//͵ַֽ
		IFADRL= ByteAddr;			//͵ַֽ;
		EA = 0;						//ж
		IFMT = ISP_READ;
		ISPCR = 0x80; 				//ISP/IAP
		SCMD = 0x46;
		SCMD = 0xB9;
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
		return IFD;
}
// ʹMOVCķʽȡIAP
#define	IAP_ReadByteByMOVC(x)	CBYTE[x]

/***********************************************************************************
:void IAP_ErasePage(u8 ByteAddr)
:ҳ, ַָڵҳ档
		һҳԼҪ30ms
:   
		 u8 ByteAddr: ָҳַ8λ
*************************************************************************************/
void IAP_ErasePage(u8 ByteAddr)
{
		bit bEA=EA;
		IFADRH = ByteAddr;		//͵ַֽ
		IFADRL= 0x00;			//͵ַֽ;
		EA = 0;					//ж
		IFMT = ISP_ERASE;
		ISPCR = 0x80; 			//ISP/IAP
		SCMD = 0x46;
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
}

/***********************************************************************************
:void IAP_WriteByte(u16 ByteAddr,u8 ByteData)
:дֽڵַָ, õַΪ(0xFF),Ҫִҳ
		 дһֽݴԼҪ80us
:   
		 u16 ByteAddr: ָIAPַ, u8 ByteData: д
ز:     
*************************************************************************************/

void IAP_WriteByte(u16 ByteAddr,u8 ByteData)
{
		bit bEA=EA;
		IFD = ByteData;				//Ҫд	
		IFADRH = ByteAddr>>8;		//͵ַֽ
		IFADRL= ByteAddr;			//͵ַֽ;
		EA = 0;						//ж
		IFMT = ISP_WRITE;
		ISPCR = 0x80;               //ISP/IAP
		SCMD = 0x46;
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
}

/***********************************************************************************
:   void IAP_ReadUID(u8 *pUID)
:ȡUID
:   
		 u8 *PUID: 洢16Byte UIDĻָ
ز:     
*************************************************************************************/
void IAP_ReadUID(u8 *pUID)
{
	u8 i;
	ISPCR=0x80;
	IFMT=0x09;
	IFADRH=0;
	IFADRL=0xF0;

	for(i=0;i<16;i++)
	{
		SCMD=0x46;
		SCMD=0xB9;
		pUID[i]=IFD;
		IFADRL++;
	}
	ISPCR=0;
	IFMT=0;
}

/***********************************************************************************
:   u8 UID_Encrypt()
:ʹUID(ΨһID)мܼ
:   
ز:0:Pass, other:Fail   
*************************************************************************************/
u8 UID_Encrypt(void)
{
	xdata u8 UID[16]; 
	u8 i;

	IAP_ReadUID(&UID[0]);

	for(i=0;i<16;i++)
	{
		if(UIDEncryptBuf[i]!=0xFF) break;
	}
	if(i<16)
	{ // 洢мֽ, ȶǷȷ
		for(i=0;i<16;i++)
		{
			if(UID[i] != UIDEncryptBuf[i]) break;
		}
		if(i<16)
		{ // ȶԴ
			return i+1;
		}
		else
		{
			return 0;
		}
	}
	else
	{ // ȫΪFF,ʾδ洢ֽ
		IAP_WritePPage(IAPLB_P,UID_ENCRYPT_BUF_ADDRESS/256);
		for(i=0;i<16;i++)
		{
			IAP_WriteByte(UID_ENCRYPT_BUF_ADDRESS+i, UID[i]);
		}
		IAP_WritePPage(IAPLB_P,ISP_ADDRESS/256);
		return 0;
	}

	return 0;
	
	
}

/***********************************************************************************/


/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitUart0_S1BRG();

}


void main()
{
	u8 i;
	bit bUIDEncryptFlag,bDeviceStringFlag;
	
	InitSystem();
	
	printf("\nHello!!");
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

	// жΨһIDǷǺ
	if(UID_Encrypt()!=0)
	{ // 
		printf("\nUID Test Fail!!");
		bUIDEncryptFlag=FALSE;
	}
	else
	{ // 
		printf("\nUID Test Pass!!");
		bUIDEncryptFlag=TRUE;
		LED_G_0=0;
	}

	// жѻкǷǺ
	bDeviceStringFlag=TRUE;
	for(i=0;i<12;i++)
	{
		if(DeviceSnString[i] != DeviceSn[i])
		{ // 
			bDeviceStringFlag=FALSE;
		}
	}

	if(bDeviceStringFlag)
	{
		printf("\nDeviceSN Test Pass!!");
		LED_G_1=0;
	}
	else
	{
		printf("\nDeviceSN Test Fail!!");
	}
	
    while(1)
	{	
		LED_R=!LED_R;
		DelayXms(100);
	}
}
