/*********************************************************************
    Ŀ:MG825Cxx-DEMO
			԰ʹ MA82G5C64 LQFP64_V10	Ev Board (TH167A)
			CpuCLK=12MHz, SysCLK=12MHz
	
			PCAʱ: 96MHz
			CH0(P62),CH1(P65),CH2(P63),CH3(P66),CH4(P64),CH5(P67)
			3Ի,ض,ֱΪ12bit
			PWMƵ: 96MHz/(4096)=23.437KHz

			P10ΪPWMP10=1:  P10=0: 
	ע

    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5Cxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5Cxx.H"
#include ".\include\API_Uart_BRGRL_MA82G5Cxx.H"


/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		24000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.25MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define IO_TEST_0		P52
#define IO_TEST_1		P53
#define IO_TEST_2		P54
#define IO_TEST_3		P55
#define IO_TEST_4		P56
#define IO_TEST_5		P57

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

idata WordTypeDef wDuty[3];

/*************************************************
:     void DelayXus(u16 xUs)
:   		ʱ,λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
:        		
:
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}


/*************************************************
:     void DelayXms(u16 xMs)
:   		ʱ,λΪms
ú:        
:     u16 xMs -> *1ms  (1~65535)
:     
:        		
:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;

	}
}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);						// P55,P56,P57Ϊ(LED)

	PORT_SetP6PushPull(BIT2|BIT3|BIT4|BIT5|BIT6|BIT7);		// CH0(P62),CH1(P65),CH2(P63),CH3(P66),CH4(P64),CH5(P67)Ϊ

	P10=1;
	PORT_SetP1OpenDrain(BIT0);						// P10Ϊ©ڿ
	PORT_EnP10P11P12P13PullHigh();					// ʹP10~P13
}

/***********************************************************************************
:   void InitPCA0_PWM(void)
:   PCAʼ
		PCAʱ: 96MHz
		CH0(P62),CH1(P65),CH2(P63),CH3(P66),CH4(P64),CH5(P67)
		3Ի,ض,ֱΪ12bit
		PWMƵ: 96MHz/(4096)=23.437KHz
:   
ز:     
*************************************************************************************/
void InitPCA1_PWM(void)
{
	PCA1_SetCLOCK_CKMIX16();			// 96MHz(ע:ʹCKMIX16/96MHz֮ǰ,ʹCKM(ENCKM=1))
	
	PCA1_CH0_SetMode_PWM();
	PCA1_CH1_SetMode_PWM();
	PCA1_CH2_SetMode_PWM();
	PCA1_CH3_SetMode_PWM();
	PCA1_CH4_SetMode_PWM();
	PCA1_CH5_SetMode_PWM();

	PCA1_CH0_SetPWM_12Bit();
	PCA1_CH1_SetPWM_12Bit();
	PCA1_CH2_SetPWM_12Bit();
	PCA1_CH3_SetPWM_12Bit();
	PCA1_CH4_SetPWM_12Bit();
	PCA1_CH5_SetPWM_12Bit();

	PCA1_CH01_SetPWM_EnBufferMode();		// CH0,CH1 ʹܻģʽ
	PCA1_CH23_SetPWM_EnBufferMode();		// CH2,CH3 ʹܻģʽ
	PCA1_CH45_SetPWM_EnBufferMode();		// CH4,CH5 ʹܻģʽ

	// PWMռձȱȽֵ
	PCA1_CH0_SetValue_12Bit(0,0);
	PCA1_CH1_SetValue_12Bit(0,0);
	PCA1_CH2_SetValue_12Bit(0,0);
	PCA1_CH3_SetValue_12Bit(0,0);
	PCA1_CH4_SetValue_12Bit(0,0);
	PCA1_CH5_SetValue_12Bit(0,0);

	// ü
	PCA1_SetCounter(0);
	PCA1_SetCounterReload(0);

	// ֹPWM
	PCA1_CH0_DisPWM();				
	PCA1_CH1_DisPWM();				
	PCA1_CH2_DisPWM();				
	PCA1_CH3_DisPWM();				
	PCA1_CH4_DisPWM();				
	PCA1_CH5_DisPWM();				

	// 
	PCA1_SetCEX0CEX1CEX2CEX3CEX4CEX5_P62P65P63P66P64P67();	// CH0(P62),CH1(P65),CH2(P63),CH3(P66),CH4(P64),CH5(P67)

	PCA1_CF_EnInterrupt();				// ʹCFж

	PCA1_EnPCACounter();				// ʹPCA, 
}



/***********************************************************************************
:   void InitClock(void)
:   ϵͳʱӳʼ
:   
ز:     
*************************************************************************************/
void InitClock()
{
	
#if (MCU_CPUCLK>=24000000)
	CLK_SetCpuCLK_HighSpeed();
#endif		


#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitPCA1_PWM();
}


void main()
{
	u8 cnt,inx;
	bit bOutFlag;
	
    InitSystem();

	LED_G_0=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;

	wDuty[0].W=0;
	wDuty[1].W=0;
	wDuty[2].W=0;
	bOutFlag=FALSE;
	
	while(1)
    {
    	DelayXms(1);
    	cnt++;
    	if(cnt>=200)
    	{
			cnt=0;
	    	LED_G_1=!LED_G_1;
	    	if(bOutFlag==TRUE)
			{
		   		inx++;
		    	if(inx>=8)
				{
					inx=0;
				}
		    	switch(inx)
				{
					case 0:
						// ռձ100% ȫߵƽ	
						// PWMռձֵ
						wDuty[0].W=0x0000;
						wDuty[1].W=0x0000;
						wDuty[2].W=0x0000;
						break;

					case 1:
						// ռձ75% 	
						// PWMռձֵ
						wDuty[0].W=0x0400;
						wDuty[1].W=0x0400;
						wDuty[2].W=0x0400;
						wDuty[3].W=0x0400;
						break;

					case 2:
						// ռձ50% 	
						// PWMռձֵ
						wDuty[0].W=0x0800;
						wDuty[1].W=0x0800;
						wDuty[2].W=0x0800;
						break;

					case 3:
						// ռձ25% 	
						// PWMռձֵ
						wDuty[0].W=0x0C00;
						wDuty[1].W=0x0C00;
						wDuty[2].W=0x0C00;
						break;
						
					case 4:
						// ռձ0% 	 ȫ͵ƽ
						// PWMռձֵ
						wDuty[0].W=0x1000;
						wDuty[1].W=0x1000;
						wDuty[2].W=0x1000;
						break;

					case 5:
						// ռձ25% 	
						// PWMռձֵ
						wDuty[0].W=0x0C00;
						wDuty[1].W=0x0C00;
						wDuty[2].W=0x0C00;
						break;

					case 6:
						// ռձ50% 	
						// PWMռձֵ
						wDuty[0].W=0x0800;
						wDuty[1].W=0x0800;
						wDuty[2].W=0x0800;
						break;

					case 7:
						// ռձ75% 	
						// PWMռձֵ
						wDuty[0].W=0x0400;
						wDuty[1].W=0x0400;
						wDuty[2].W=0x0400;
						break;
						
		    	}
				// ģʽ,CH0/CH1ֵĴΪCH1ֵ
				PCA1_CH1_SetValue_12Bit(wDuty[0].B.BHigh,wDuty[0].B.BLow);
				// ģʽ,CH2/CH3ֵĴΪCH3ֵ
				PCA1_CH3_SetValue_12Bit(wDuty[1].B.BHigh,wDuty[1].B.BLow);
				// ģʽ,CH4/CH5ֵĴΪCH5ֵ
				PCA1_CH5_SetValue_12Bit(wDuty[2].B.BHigh,wDuty[2].B.BLow);
	    	}
    	}
    	if(P10==1)
    	{
			if(bOutFlag==FALSE)
			{
				bOutFlag=TRUE;
				LED_R=0;
				// ʹPWM
				PCA1_CH0_EnPWM();					
				PCA1_CH1_EnPWM();
				PCA1_CH2_EnPWM();
				PCA1_CH3_EnPWM();
				PCA1_CH4_EnPWM();
				PCA1_CH5_EnPWM();
			}
    	}
    	else
    	{
			if(bOutFlag==TRUE)
			{
				bOutFlag=FALSE;
				LED_R=1;
				// ֹPWM
				PCA1_CH0_DisPWM();					
				PCA1_CH1_DisPWM();
				PCA1_CH2_DisPWM();
				PCA1_CH3_DisPWM();
				PCA1_CH4_DisPWM();
				PCA1_CH5_DisPWM();
			}
    	}
    }
}




