/*********************************************************************
*    Ŀ:MG82F6D16-DEMO
*			԰ʹ MG82F6Dxx	SSOP28 EV Board (TH189A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			RTCʱΪILRCO 32KHz
*			RTC Clock ԤƵ 32
*			RTC ֵ (64-10)=54
*			RTCƵΪ 32K/32/10 ~= 100Hz
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D16.H"
#include ".\include\API_Uart_BRGRL_MG82F6D16.H"


/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.25MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26


/***********************************************************************************
* :   void INT_SF(void)
*:SF(ϵͳ־λ)жϷ
		 RTC,WDTF,BOD0F,BOD1F
*:   
*ز:     
*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1&WDTF)!=0)
	{
		PCON1=WDTF;
	}
	if((PCON1&BOF0)!=0)
	{
		PCON1=BOF0;
	}
	if((PCON1&BOF1)!=0)
	{
		PCON1=BOF1;
	}
	if((PCON1&RTCF)!=0)
	{
		PCON1=RTCF;
		LED_R=!LED_R;
	}
}


/*************************************************
* :        void DelayXus(u16 xUs)
*:   	ʱ,λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
* :        void DelayXms(u16 xMs)
*:     ʱ,λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}
/***********************************************************************************
* :   void InitRTC(void)
*:RTC ʼ	
*		RTCʱΪILRCO 32KHz
*		RTC Clock ԤƵ 32
*		RTC ֵ (64-10)=54
*		RTCƵΪ 32K/32/10=100Hz
*:   
*ز:     
*************************************************************************************/
void InitRTC(void)
{	
	RTC_SetClock_ILRCO();		// ѡRTCʱΪ ILRCO 32KHz
	RTC_SetClock_Div_32();		// ѡRTC Clock ԤƵ 32
	RTC_SetReload(64-10);		// RTC ֵ (64-10)=54
	RTC_SetCounter(64-10);

	RTC_EnRTCO_OutP45();		// ʹRTCP45
	
	RTC_ClearRTCF();			// RTCF
	RTC_Enable();				// ʹRTC
	
}


/***********************************************************************************
* :   void InitInterrupt(void)
*:InitInterruptʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_RTC();			// ʹRTCж,ʹϵͳ־ж
	INT_EnSF();				// ʹϵͳ־ж

	
}

/***********************************************************************************
* :   void EnP44P45GPIO(void)
*:   P44P45GPIO, ֹOCD
*		ע: ú,P44/P45޷OCD-ICE, 
*:   
*ز:     
*************************************************************************************/
void EnP44P45GPIO(void)
{
	u8 x;
	bit bEA=EA;
	ISPCR=0x80;
	IFADRH=0x00;
	IFADRL=DCON0_P;
	IFMT=ISP_READ_P;
	SCMD=0x46;
	SCMD=0xB9;
	_nop_();
	x=IFD;
	x=x&(~OCDE_P);
	IFD=x;
	IFMT=ISP_WRITE_P;
	SCMD=0x46;
	SCMD=0xB9;
	_nop_();
	ISPCR=0x00;
	IFMT=ISP_STANBY;
	
}

/***********************************************************************************
* :   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	EnP44P45GPIO();
	
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);					//  P22,P24,P26 Ϊ LED
	PORT_SetP4OpenDrainPu(BIT4|BIT5);
}



/***********************************************************************************
* :   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	
	InitRTC();			

	InitInterrupt();		// жϳʼ
	
	INT_EnAll();			// ʹȫж

}



void main()
{
	
    InitSystem();
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
    	DelayXms(100);
    	LED_G_0=!LED_G_0;
    }
}

