/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			ADC 10bit, P33Ϊ
*			ڲ1.4VȽ,Ƶʵʵѹ
*ע:
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
//#define LED_G_0		P33
#define LED_G_1		P46


#define TEST_ADC_DATA_CNT		16
xdata WordTypeDef TestBuf[TEST_ADC_DATA_CNT];
xdata WordTypeDef TestIVRBuf[TEST_ADC_DATA_CNT];
u8 TestBufLen;

#define VCC_REF					(3300L)
#define ADC_VALUE_MAX			(1024L)
#define IVR_ADC_MIN				(403L)		// 1.3v@3.3V 
#define IVR_ADC_MAX				(465L)		// 1.5v@3.3V
#define IVR_ADC_DEFAULT			(434L)		// 1.4v@3.3V

/*************************************************
*: char putchar (char c)   
*: printf Ĵ
*:     char c
*:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitUart0_S0BRG(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);

	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2); 				//  P30,P31,P32Ϊ˫,RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);					//  P46Ϊ©,LED
	PORT_P33_EnAnalogOnly();  						//  P33ģ룬ADCͨ
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ	
*:   
*:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(0);						// T08λ
	TM_SetT0HighByte(0);					// T08λ

	TM_DisableT0();							// ֹT0
}

/***********************************************************************************
*:   void InitADC(void)
*:   ADCʼ
*:   
*:     
*************************************************************************************/
void InitADC(void)
{
	ADC_Enable();						// ʹADC
	ADC_SetClock_SYSCLKDiv2();			// ADCתʱΪ SYSCLK/2       ת= 8M/2/24=83.3k
	ADC_SetMode_SetADCS();				// ADCģʽ, ADCS
	ADC_SetRightJustified();			// ADCתҶ
	ADC_SetADCData_10Bit();				// ADC 10bit

	IVREF_Enable();						// ʹڲ2.4V
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}


/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitUart0_S0BRG();
	InitADC();
	InitTimer0();
}

/***********************************************************************************
*:   u16 GetAdcData()
*:	ȡǰͨADC 
*:   
*:   u16 :ADC Value
*************************************************************************************/
u16 GetAdcValue()
{
	WordTypeDef wAdcValue;
	ADCON0 = ADCON0|ADCS;							// λADCS,ADC
    while((ADCON0&ADCI)==0);           				// ȴADCת
    wAdcValue.B.BHigh=ADCDH;
    wAdcValue.B.BLow=ADCDL;
 	ADCON0 = ADCON0&(~ADCI);		           		// ־λ
	return wAdcValue.W&0x03FF;
}

/***********************************************************************************
*:   unsigned int GetIVRef()
*:   ȡڲIVRefУ׼ֵ
*:   
*ز:   unsigned int :IVRef 3.3VµADCֵ
*************************************************************************************/
unsigned int GetIVRef()
{
unsigned char IVR_CodeHigh,IVR_CodeLow;
	while((ISPCR&PBSY)!=0);
	
	ISPCR = 0x80;
	IFMT = 0x06;
	IFADRH = 0x00;
	IFADRL = 0x4C;
	
	SCMD = 0x46;
	SCMD = 0xB9;
	IVR_CodeHigh= IFD;

	IFADRL ++;
	SCMD = 0x46;
	SCMD = 0xB9;
	IVR_CodeLow= IFD;

	ISPCR = 0x00;
	
	return (IVR_CodeHigh*256+IVR_CodeLow);
}

void main()
{
	u8 i;
	DWordTypeDef dwTemp,dwIVR;
	WordTypeDef wVinValue,wIVRefValue;
	WordTypeDef wIVRAdjAdc;

	u16 wAdcMIN,wAdcMAX,wAdcAVG;
	WordTypeDef wAdcTime;
	
    InitSystem();
	
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;
	
	printf("\nHello...");

	wIVRAdjAdc.W=GetIVRef(); 			

	// 
	printf("\nIVR ADC@3.3V:%d",wIVRAdjAdc.W);
	// IVRefУ׼ֵǷڷΧ(1.3~1.5)
	if((wIVRAdjAdc.W <IVR_ADC_MIN)||(wIVRAdjAdc.W>=IVR_ADC_MAX))
	{ // 洢IVRefֵ,ΪĬֵ 1.4V@3.3V
		// 
		wIVRAdjAdc.W=IVR_ADC_DEFAULT;
		printf(" Err..Set Default:%d",wIVRAdjAdc.W);
	}
	// IVRĵѹֵ
	dwTemp.DW=wIVRAdjAdc.W;
	wIVRefValue.W=dwTemp.DW*VCC_REF/ADC_VALUE_MAX;
	printf(", VRef Voltage:%dmV",wIVRefValue.W);


	TestBufLen=0;

	TH0=0;
	TL0=0;
	TM_EnableT0();
    while(1)
    {
    	// IOADCֵ
    	ADC_SetChannel_AIN5_P33();
    	DelayXus(10);
    	TestBuf[TestBufLen].W=GetAdcValue();

    	// IVRADCֵ
    	ADC_SetChannel_IVR14();
    	DelayXus(10);
    	TestIVRBuf[TestBufLen].W=GetAdcValue();
    	
		LED_R = !LED_R;
		
		TestBufLen++;
		if(TestBufLen>=TEST_ADC_DATA_CNT)
		{
			TM_DisableT0();
			wAdcTime.B.BHigh=TH0;
			wAdcTime.B.BLow=TL0;

			dwIVR.DW=0;
			dwTemp.DW=0;
			wAdcMIN=0xFFFF;
			wAdcMAX=0x0000;
			
			for(i=0;i<(TEST_ADC_DATA_CNT);i++)
			{
				dwIVR.DW=dwIVR.DW+TestIVRBuf[i].W;
				dwTemp.DW=dwTemp.DW+TestBuf[i].W;
				if(wAdcMIN>=TestBuf[i].W)
				{
					wAdcMIN=TestBuf[i].W;
				}
				if(wAdcMAX<TestBuf[i].W)
				{
					wAdcMAX=TestBuf[i].W;
				}
				
			}
			wAdcAVG=dwTemp.DW/TEST_ADC_DATA_CNT;		
			printf("\nADC ");
			printf("Sample cnt:%bd,",i);
			printf("Total time:%d,",wAdcTime.W);
			printf("MIN:%04X,",wAdcMIN);
			printf("MAX:%04X,",wAdcMAX);
			printf("AVG:%04X,",wAdcAVG);

			
			// AIN0ѹֵ
			dwIVR.DW=dwIVR.DW/TEST_ADC_DATA_CNT;
			dwTemp.DW=wIVRAdjAdc.W;
			wVinValue.W=(dwTemp.DW*wAdcAVG*VCC_REF)/(dwIVR.DW*ADC_VALUE_MAX);
			
			// 
			printf("IO Voltage:%dmV",wVinValue.W);
			DelayXms(1000);
			TestBufLen=0;

			TH0=0;
			TL0=0;
			TM_EnableT0();
		}
    }
}



