/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*Description:
*			BOD0, BOD1 test
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46


bit bBOD1Flag;

/***********************************************************************************
*Function:    void INT_SF(void)
*Description: SF Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1 & BOF0)!=0)
	{ // BOD0 interrupt, 2.35V
		PCON1=BOF0;
	}

	if((PCON1 & BOF1)!=0)
	{ // BOD1 interrupt, 4.2V/3.6V/2.7V/2.4V
		bBOD1Flag = 1;
		PCON1=BOF1;
		// To do......
		INT_DisSF_BOD1();			// Disable BOD1 interrupt
	}

	if((PCON1 & WDTF)!=0)
	{ // WDT interrupt
		PCON1=WDTF;
	}

	if((PCON1 & RTCF)!=0)
	{ // RTC interrupt
		PCON1=RTCF;
	}

}


/*************************************************
*Function:     void DelayXus(u8 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitInterrupt(void)
*Description:   Initialize Interrupt 
*Input:   
*Output:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_BOD1();			// Enable BOD1 interrupt
	INT_EnSF();					// Enable SF interrupt
	
}	

/***********************************************************************************
*Function:   void InitBOD(void)
*Description:   Initialize BOD
*Input:   
*Output:     
*************************************************************************************/
void InitBOD(void)
{
	// Set detect 2.7V, Disable BOD1 on PD Mode, Disable BOD1 reset mcu, Enable BOD0 reset mcu
	POW_SetPCON2(POW_BOD1_Disable|POW_BOD1_Set27V|POW_BOD1_Disable_OnPD|POW_BOD1_DisReset|POW_BOD0_EnReset);
	// Detect 2.7, need set CON4.4,
	POW_SetPCON4(POW_BOD1_PCON4_27V);
	// Clear BOF1
	INT_ClrSF_BOD1();
	// Enable BOD1
	POW_SetPCON2(POW_BOD1_Enable|POW_BOD1_Set27V|POW_BOD1_Disable_OnPD|POW_BOD1_DisReset|POW_BOD0_EnReset);
	
}	



/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as Quasi-Bidirectional,for RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				// Set P46 as Open-Drain with pull-up resistor,for LED
}


/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitBOD();
	InitInterrupt();

	INT_EnAll();  // Enable global interrupt
}



void main()
{
    InitSystem();

	bBOD1Flag=0;
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

    while(1)
    {
		DelayXms(200);
		LED_G_0=!LED_G_0;
		if(bBOD1Flag)
		{
			if((PCON1 & BOF1)!=0)
			{// BOF1 set,VDD<2.7V
				LED_R=0;
				PCON1 = PCON1 | BOF1;	// Clear flag
			}
			else
			{// VDD>2.7V
				LED_R=1;
				bBOD1Flag = FALSE;
				INT_EnSF_BOD1();			// Power voltage restored. Enable BOD1 interruption
			}
		}
    }
}

