/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*Description:
*			T0 mode 0:8bit PWM, output to P46,PWM freq:Sysclk/12/256	
*			T1 mode 0:8bit PWM, output to P33,PWM freq:Sysclk/1/256
*
*Note:
* 			Duty cycle cannot be 100% and needs to be handled by software.
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46


/*************************************************
*Function:     void DelayXus(u8 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitTimer0(void)
*Description:Initialize Timer0	
*Input:   
*Output:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_0_8BIT_PWM();						// TIMER0 Mode: 8bit PWM
	TM_SetT0Clock_SYSCLKDiv12();					// TIMER0 Clock source:SYSCLK/12
	TM_SetT0Gate_Disable();
	TM_SetT0LowByte(0);								// Set TL0 value
	TM_SetT0HighByte(0);							// Set TH0 value
	TM_SetT0CKO_P46();								// set T0CKO to P46
	TM_EnT0CKO();									// Enable T0CKO output	
	TM_EnableT0();									// Enable T0
}

/***********************************************************************************
*Function:   void InitTimer1(void)
*Description:Initialize Timer1
*Input:   
*Output:     
*************************************************************************************/
void InitTimer1(void)
{
	TM_SetT1Mode_0_8BIT_PWM();						// TIMER1 Mode: 8bit PWM
	TM_SetT1Clock_SYSCLK();							// TIMER1 Clock source:SYSCLK
	TM_SetT1Gate_Disable();
	TM_SetT1LowByte(0);								// Set TL1 value
	TM_SetT1HighByte(0);							// Set TH1 value
	TM_SetT1CKO_P33();								// set T1CKO to P33
	TM_EnT1CKO();									// Enable T1CKO output
	TM_EnableT1();									// Enable T1
}

/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as Quasi-Bidirectional,for RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				// Set P46 as Open-Drain with pull-up resistor,for LED
}


/***********************************************************************************
*Function:   void InitClock(void)
*Description:   Initialize clock	
*Input:   
*Output:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45 ouput MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitClock();
	
	InitTimer0();			
	InitTimer1();

}



void main()
{
	u8 i;
	
    InitSystem();
	
 	LED_R=0;
	DelayXms(1000);
 	LED_R=1;

					
    while(1)
    {
    	DelayXms(100);
    	LED_R=!LED_R;
    	i++;
    	if(i>=10)
    	{
			i=0;
    	}
    	switch(i)
    	{
			case 0:// 0% ALL High
				TH0=(0*256/100);
				TH1=(0*256/100);
				break;
			case 1:// 20% 
				TH0=(20*256/100);
				TH1=(20*256/100);
				break;
			case 2:// 40% 
				TH0=(40*256/100);
				TH1=(40*256/100);
				break;
			case 3:// 70% 
				TH0=(70*256/100);
				TH1=(70*256/100);
				break;
			case 4:// 90% 
				TH0=(90*256/100);
				TH1=(90*256/100);
				break;
			case 5:// 100% All Low
				P46=0;
				TM_DisT0CKO();
				P33=0;
				TM_DisT1CKO();
				break;
			case 6:// 90% 
				TH0=(90*256/100);
				TH1=(90*256/100);
				P46=1;
				TM_EnT0CKO();
				P33=1;
				TM_EnT1CKO();
				break;
			case 7:// 70% 
				TH0=(70*256/100);
				TH1=(70*256/100);
				break;
			case 8:// 40% 
				TH0=(40*256/100);
				TH1=(40*256/100);
				break;
			case 9:// 20% 
				TH0=(20*256/100);
				TH1=(20*256/100);
				break;
			default:
				i=0;
				break;
    	}
    }
}

