/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=24MHz, SysCLK=24MHz
*	
*			SPI(nSS/P33,MOSI/P15,MISO/P16,SPICLK/P17) дEN25Q32A
*			SPI ʱΪ 24MHz/4=6MHz
*	ע
*	
*    ʱ:
*    ޸־:
*    
**********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf
#include <string.h>

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		24000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

#define SPI_nSS		P14


// SPI FLASH
#define Dummy_Data					0xFF
#define FLASH_BLOCK_SIZE			(64L*1024L)					// 64K Byte

#define FLASH_TEST_START_ADDRESS	0x00000000
#define FLASH_TEST_SIZE_MAX			(1024L*1024L)				// 1M Byte

#define FLASH_WRITE_ENABLE_TIME_MAX		(15+5)					// 15ms
#define FLASH_WRITE_STATUS_TIME_MAX		(15+5)					// 15ms
#define FLASH_PAGE_PROGRAM_TIME_MAX		(5+5)					// 5ms
#define FLASH_SECTOR_ERASE_TIME_MAX		(300+100)				// 300ms
#define FLASH_BLOCK_ERASE_TIME_MAX		(2000+500)				// 2s
#define FLASH_CHIP_ERASE_TIME_MAX		(50000+5000)			// 50s


u16 FlashOverTime;

xdata u8 TestBuf[512];
xdata u8 TestRxBuf[512];

DWordTypeDef dwTime;

/***********************************************************************************
*:   void INT_T0(void)
*:T0 жϷ
*:   
*:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	dwTime.W.WHigh++;
}

/***********************************************************************************
*:   void INT_T1(void)
*:T1 жϷ
*:   
*:     
*************************************************************************************/
void INT_T1(void) interrupt INT_VECTOR_T1
{
	TM_SetT1LowByte(TIMER_12T_1ms_TL);					// T18λ
	TM_SetT1HighByte(TIMER_12T_1ms_TH);					// T18λ
	if(FlashOverTime !=0) FlashOverTime--;
}

/*************************************************
*: char putchar (char c)   
*: printf Ĵ
*:     char c
*:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ
*:   
*:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv48();			// T0ʱԴΪ SYSCLK/48
	TM_SetT0Gate_Disable();
	TM_SetT0LowByte(0);						// T08λ
	TM_SetT0HighByte(0);					// T08λ
	//TM_EnableT0();						// ʹT0
}

/***********************************************************************************
*:   void InitTimer1(void)
*:Timer1ʼ
*:   
*:     
*************************************************************************************/
void InitTimer1(void)
{
	TM_SetT1Mode_1_16BIT_TIMER();			// T1ģʽΪ16λģʽ
	TM_SetT1Clock_SYSCLKDiv12();			// T1ʱԴΪ SYSCLK/12
	TM_SetT1Gate_Disable();

	TM_SetT1LowByte(TIMER_12T_1ms_TL);						// T18λ
	TM_SetT1HighByte(TIMER_12T_1ms_TH);					// T18λ

	TM_EnableT1();							// ʹT1
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(0xFF);							//  P2 Ϊ©
	PORT_EnP24P25P26P27PullHigh();						// ʹ P24,P25,P26,P27 

	PORT_SetP1PushPull(BIT4|BIT5|BIT7);					//  P14(nSS),P15(MOSI),P17(SPICLK)Ϊ
	PORT_SetP1OpenDrain(BIT6);							//  P16(MISO)Ϊ©
	PORT_EnP14P15P16P17PullHigh();						// ʹ P14,P15,P16,P17 
}

/***********************************************************************************
*:   void InitUart0_S1BRG(void)
*:   Uart0ʼ ,ʹS1BRGΪԴ
*:   
*:     
*************************************************************************************/
void InitUart0_S1BRG(void)
{	
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART1
	UART0_SetBRGFromS1BRG();			// òԴΪ S1BRG
	UART0_SetS1BRGBaudRateX2();			// 2x
	UART1_SetS1BRGSelSYSCLK();			// S1BRGʱΪSysclk

    // ò
	UART1_SetS1BRGValue(S1BRG_BRGRL_9600_2X_24000000_1T);
	
	UART1_EnS1BRG();					// S1BRGʱ
}

/***********************************************************************************
*:   void InitInterrupt(void)
*:InitInterruptʼ
*:   
*:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();
	INT_EnTIMER1();
	
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*:   void InitSPI_Master(void)
*:   SPIʼ
*:   
*:     
*************************************************************************************/
void InitSPI_Master(void)
{
	// ʹSPI
	SPI_Enable();
	// MASTER
	SPI_SelectMASTERByMSTRbit();
	// SPIʱ SYSCLK/4 24M/4=6M
	SPI_SetClock(SPI_CLK_SYSCLK_4);
	// SPICLKʼƽ CPOL=0 ͵ƽ
	SPI_SetCPOL_0();	
	// ݴλ MSB λǰ
	SPI_SetDataMSB();
	// ò͸ıģʽ CPHA=0 ǰز,ظı
	SPI_SetCPHA_0();
	// IO nSS/P14,MOSI/P15,MISO/P16,SPICLK/P17
	SPI_SetUseP14P15P16P17();

}

/***********************************************************************************
*:  void Reset_Counter(void)
*:	ü
*:   
*:   		
*************************************************************************************/
void Reset_Counter(void)
{
	// رT0
	TM_DisableT0();
	dwTime.DW=0x00000000;
	TM_SetT0HighByte(0);
	TM_SetT0LowByte(0);
	// ʹT0
	TM_EnableT0();
}

/***********************************************************************************
*:  void Send_Counter(void)
*:	ͼ
*:   
*:   		
*************************************************************************************/
void Send_Counter(void)
{
	TM_DisableT0();
	dwTime.B.BMLow=TH0;
	dwTime.B.BLow=TL0;
	printf("%ldus",dwTime.DW*2);
}

/***********************************************************************************
*:   u8 SPITransceiver(u8 ToSend)
*:   SPIģʽշ
*:   u8 SPI_DATA: ͵
*:   u8 :յ  
*************************************************************************************/
u8 SPITransceiver(u8 SPI_DATA)
{
	SPI_SendData(SPI_DATA);							// SPI 
	while(SPI_ChkCompleteFlag()==0);				// ȴSPI
	SPI_ClearCompleteFlag();						// SPI ɱ־
	return SPI_GetData();							// ؽյ
}


/*
*************************************************************************************
*  SPI FLASH EN25Q32A
*
*************************************************************************************
*/

/***********************************************************************************
*:	u8 SPI_Flash_1ByteRead (u32 Address)
*:	ȡEN25Q32AַָһBYTE 
*:	uint32_t Address: 24λַָ 0x00000000 ~ 0xFFFFFFFF
*: uint8_t ȡ	  
*************************************************************************************/
u8 SPI_Flash_1ByteRead (u32 Address)
{ 
	u8 x;
	SPI_nSS = 0;
    
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Address>>16));
    SPITransceiver((u8)(Address>>8));
    SPITransceiver((u8)(Address));
    
    /* Read data */
    x=SPITransceiver(Dummy_Data);

	SPI_nSS = 1;

    return  x;
}

/***********************************************************************************
*:	void SPI_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u32 Length)
*:	ȡEN25Q32AַָĶBYTE 
*:	  u32 Address: 24λַָ 0x00000000 ~ 0xFFFFFFFF
*		  u8 *BufferAddreass: 洢ȡݵĻַ
*		  u16 Length: ȡݵĳ
*: 
*************************************************************************************/
void SPI_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u16 Length)
{
	SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Address>>16));
    SPITransceiver((u8)(Address>>8));
    SPITransceiver((u8)(Address));
    
    /* Read data */
    while(Length !=0)
	{
		*BufferAddreass=SPITransceiver(Dummy_Data);
        BufferAddreass ++;
        Length--;
	}
	SPI_nSS = 1;
}

/***********************************************************************************
*:	u32 SPI_Flash_Read_ID (void)
*:	ȡEN25Q32A ID 
*:	
*: uint32_t ȡID 
*************************************************************************************/
u32 SPI_Flash_Read_ID (void)
{
	DWordTypeDef RDAT;
    
    SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x9F);
    
    /* Read ID */
    RDAT.B.BHigh=0x00;
    RDAT.B.BMHigh=SPITransceiver(Dummy_Data);
    RDAT.B.BMLow=SPITransceiver(Dummy_Data);
    RDAT.B.BLow=SPITransceiver(Dummy_Data);
	SPI_nSS  = 1;
    
    return RDAT.DW;
}

/***********************************************************************************
*:	u8 SPI_Flash_Write_Enable (void)
*: ʹдFlash
*:	
*: 0:ɹ, 1:ʧ
*************************************************************************************/
u8 SPI_Flash_Write_Enable(void)
{
	u8 RDAT;
    FlashOverTime=FLASH_WRITE_ENABLE_TIME_MAX;
    while(FlashOverTime!=0)
    {
	    /* Write enable */
		SPI_nSS  = 0;
		SPITransceiver(0x06);
		SPI_nSS  = 1;

		nop();
		nop();
		nop();
		nop();
		nop();
	    /* Read status register */
		SPI_nSS  = 0;
		SPITransceiver(0x05);			//RDSR
	
		RDAT = SPITransceiver(Dummy_Data);                                  // Get received data

		SPI_nSS  = 1;

	    /* Check WEL == 1 */
		if((RDAT & 0x02) != 0x00)
		{
			return 0;
		}
	}
	return 1;
}

/***********************************************************************************
*:	u8 SPI_Flash_Check_Busy(void)
*:	EN25Q32AǷæ
*:	BusyTimeMax: ʱ
*: 0:ɹ, 1:ʧ
*************************************************************************************/
u8 SPI_Flash_Check_Busy(u16 BusyTimeMax)
{
	u8 RDAT;
	
    FlashOverTime=BusyTimeMax;

    while(FlashOverTime!=0)
    {
	    /* Read status register */
		SPI_nSS  = 0;
		SPITransceiver(0x05);							//RDSR

		RDAT = SPITransceiver(Dummy_Data);              // Get received data
		
	    /* Check erase or write complete */
		SPI_nSS  = 1;
	
		if((RDAT & 0x01) == 0x00)						
		{
			return 0;
		}
	}
	return 1;
}

/***********************************************************************************
*:	u8 SPI_Flash_Write_Status(u8 uStatus)
*:	EN25Q32A д״̬
*:	u8 uStatus:Ҫд״̬
*: 0:ɹ, 1:ʧ 
*************************************************************************************/ 
u8 SPI_Flash_Write_Status(u8 uStatus)
{
    if(SPI_Flash_Write_Enable()!=0) return 1;
    
	SPI_nSS  = 0;
	SPITransceiver(0x01);                               			// Write Status Register(WRSR) command 
                
	
    /* Write Status */
    SPITransceiver(uStatus);
	
	SPI_nSS  = 1;
   
	return 0;
}

/***********************************************************************************
*:	u8 SPI_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
*:	EN25Q32A д
*:	u32 Addr: дʼַ. 0x00000000 ~ 0xFFFFFFFF.
*		  u8 *DataSource: дݻʼַ. 
*		  u16 Length: дݳ, 256ֽ
*: 0:ɹ, 1:ʧ 
*************************************************************************************/ 
u8 SPI_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
{
    if(SPI_Flash_Write_Enable()!=0) return 1;
    
	SPI_nSS  = 0;
	SPITransceiver( 0x02);                               // Write command 
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	while(Length!=0)                                     // Write Data
	{
		SPITransceiver(*DataSource);
        DataSource++;
		Length--;
	}
	
	SPI_nSS  = 1;
   
	return SPI_Flash_Check_Busy(FLASH_PAGE_PROGRAM_TIME_MAX);
}

/***********************************************************************************
*:	u8 SPI_Flash_Block_Erase(u32 Addr)
*:	EN25Q32A 
*:	u32 Addr: ҪBlock ĵַ.
*: 0:ɹ, 1:ʧ  
*************************************************************************************/ 
u8 SPI_Flash_Block_Erase(u32 Addr)
{
    if(SPI_Flash_Write_Enable()!=0) return 1;
    
	SPI_nSS  = 0;
	SPITransceiver(0xD8);                               			// Block Erase command 
                
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	SPI_nSS  = 1;
   
	return SPI_Flash_Check_Busy(FLASH_BLOCK_ERASE_TIME_MAX); 
}

/*
*************************************************************************************
*/ 

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitClock();
	InitSPI_Master();			
	InitUart0_S1BRG();
	InitTimer0();
	InitTimer1();
	InitInterrupt();		// жϳʼ
	
	INT_EnAll();			// ʹȫж
}

void main()
{
	u32 i;
	u8 x;
	
	DWordTypeDef dwTemp;
	
    InitSystem();
	
	printf("\nHello!");
	LED_G_1=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;LED_G_0=0;

	// оƬID
	dwTemp.DW=SPI_Flash_Read_ID();
	printf("\r\nFlash ID: %08lX",dwTemp.DW);
	DelayXms(10);

	// д
	SPI_Flash_Write_Status(0x00);
	DelayXms(10);
	
	printf("\r\nFlash Erase...");
	i=FLASH_TEST_SIZE_MAX/FLASH_BLOCK_SIZE;
	// Flash
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	Reset_Counter();
	while(i!=0)
	{
		LED_R = 0;
		if(SPI_Flash_Block_Erase(dwTemp.DW)!=0) break;
		LED_R = 1;
		dwTemp.DW=dwTemp.DW+FLASH_BLOCK_SIZE;
		i--;
	}
	LED_R = 1;
	if(i==0)
	{
		Send_Counter();
	}
	else
	{
		printf("Fail (%ld)",i);
		goto TEST_END;
	}

	x=0;
	for(i=0;i<512;i++)
	{
	  TestBuf[i]=x;
	  x++;
	}
	// дFlash
	printf("\r\nFlash Write 1M...");
	i=FLASH_TEST_SIZE_MAX/256;	  
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	Reset_Counter();
	while(i!=0)
	{
	  LED_R = 0;
	  if(SPI_Flash_Page_Program(dwTemp.DW,&TestBuf[0],256)!=0) break;
	  LED_R = 1;
	  dwTemp.DW=dwTemp.DW+256;
	  i--;
	}
	LED_R = 1;
	if(i==0)
	{
		Send_Counter();
	}
	else
	{
		printf("Fail (%ld)",i);
		goto TEST_END;
	}
	
	// Flash У
	printf("\r\nFlash Read 1M...");
	i=FLASH_TEST_SIZE_MAX/512;	  
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	Reset_Counter();
	while(i!=0)
	{
		LED_R = 0;
		SPI_Flash_MultiBytesRead(dwTemp.DW,&TestRxBuf[0],512);
		LED_R = 1;
		if(memcmp(&TestBuf[0],&TestRxBuf[0],512)!=0) break;
		dwTemp.DW=dwTemp.DW+512;
		i--;
	}
	LED_R = 1;
	if(i==0)
	{
		Send_Counter();
	}
	else
	{
		printf("Fail (%ld)",i);
		goto TEST_END;
	}

TEST_END:
    while(1)
    {
    	DelayXms(100);
		LED_G_1 = !LED_G_1;
    }
}







