/*********************************************************************
*    Ŀ:MG82F6D16-DEMO
*			԰ʹ MG82F6Dxx	SSOP28 EV Board (TH189A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			IAP 
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D16.H"
#include ".\include\API_Uart_BRGRL_MG82F6D16.H"


/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.25MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26


#define IAP_ADDRESS    0x3800	 //IAPʼַ  

uchar TrapFlag[3]; 

/*************************************************
* : char putchar (char c)   
*: printf Ĵ
*:     char c
*ز:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
* :        void DelayXus(u16 xUs)
*:   	ʱ,λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
* :        void DelayXms(u16 xMs)
*:     ʱ,λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
* :      	void CheckTrapFlag(void)
*:   	Ƿȷ̽IAPֹ
*				TrapFlag != 'Win',ʾǷǷ,Ƭλ
*:   	
*ز:     
*************************************************************************************/
void CheckTrapFlag(void)
{ 
	if ((TrapFlag[0]!='W')||(TrapFlag[1]!='i')||(TrapFlag[2]!='n'))
	{
		//λ
		ISPCR=SRST;
	}
}


/***********************************************************************************
* :   u8 IAP_ReadPPage(u8 PsfrAddr)
*:ȡPҳ⹦
*:   
*		 u8 PsfrAddr: Pҳַ
*ز:     
*		 u8: Pҳ
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;			//
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	CheckTrapFlag();
	SCMD = 0x46;
	CheckTrapFlag();
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
	return IFD;
}


/***********************************************************************************
* :void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
*:дPҳ⹦
*:   
*		 u8 PsfrAddr: Pҳַ,u8 PsfrData:  Pҳ
*ز:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;			//
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	CheckTrapFlag();
	SCMD = 0x46;
	CheckTrapFlag();
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}


/***********************************************************************************
* :u8 IAP_ReadByte(u16 ByteAddr)
*:ַָIAP
*:   
*		 u16 ByteAddr: IAPַ
*ز:     
*************************************************************************************/
u8 IAP_ReadByte(u16 ByteAddr)
{
		bit bEA=EA;
		IFADRH = ByteAddr>>8;		//͵ַֽ
		IFADRL= ByteAddr;			//͵ַֽ;
		EA = 0;						//ж
		IFMT = ISP_READ;			//
		ISPCR = 0x80; 				//ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
		return IFD;
}
// ʹMOVCķʽȡIAP
#define	IAP_ReadByteByMOVC(x)	CBYTE[x]

/***********************************************************************************
* :void IAP_ErasePage(u8 ByteAddr)
*:ҳ, ַָڵҳ档
*		һҳԼҪ30ms
*:   
*		 u8 ByteAddr: ָҳַ8λ
*************************************************************************************/
void IAP_ErasePage(u8 ByteAddr)
{
		bit bEA=EA;
		IFADRH = ByteAddr;		//͵ַֽ
		IFADRL= 0x00;			//͵ַֽ;
		EA = 0;					//ж
		IFMT = ISP_ERASE;		//
		ISPCR = 0x80; 			//ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
}

/***********************************************************************************
* :void IAP_WriteByte(u16 ByteAddr,u8 ByteData)
*:дֽڵַָ, õַΪ(0xFF),Ҫִҳ
*		 дһֽݴԼҪ80us
*:   
*		 u16 ByteAddr: ָIAPַ, u8 ByteData: д
*ز:     
*************************************************************************************/

void IAP_WriteByte(u16 ByteAddr,u8 ByteData)
{
		bit bEA=EA;
		IFD = ByteData;				//Ҫд	
		IFADRH = ByteAddr>>8;		//͵ַֽ
		IFADRL= ByteAddr;			//͵ַֽ;
		EA = 0;						//ж
		IFMT = ISP_WRITE;			//
		ISPCR = 0x80;               //ISP/IAP
		CheckTrapFlag();
		SCMD = 0x46;
		CheckTrapFlag();
		SCMD = 0xB9;
		nop();
		IFMT=0;
		ISPCR = 0;					//ISP/IAPĴֹ
		EA = bEA; 					//ָж
}


/***********************************************************************************
* :   void InitUart0_T1(void)
*:   Uart0ʼ,ʹT1ΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_T1(void)
{
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART0
	UART0_SetBRGFromT1();				// òԴΪ T1
	UART0_SetT1BaudRateX2();			// 2x

	TM_SetT1Mode_2_8BIT_AUTORELOAD();
	TM_SetT1Clock_SYSCLK();
	TM_SetT1Gate_Disable();

    // ò
	TM_SetT1HighByte(T1_BRGRL_9600_2X_12000000_1T);
	TM_SetT1LowByte(T1_BRGRL_9600_2X_12000000_1T);

	TM_EnableT1();
	
}


/***********************************************************************************
* :   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);					//  P22,P24,P26 Ϊ LED
	PORT_SetP1OpenDrainPu(BIT0);						// P10 Ϊ©ģʽ
}




/***********************************************************************************
* :   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{

	InitPort();
	InitUart0_T1();

	TrapFlag[1]='i';

}


void main()
{
	BYTE IAPData;
	BYTE i;
	BYTE rand;
	bit bOK=TRUE;

	TrapFlag[0]='W';TrapFlag[1]=0xFF;TrapFlag[2]=0xFF;
	
    InitSystem();
    
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	printf("\nStart IAP DEMO!");
	LED_G_0=1;LED_G_1=1;LED_R=1;

	
	TrapFlag[2]='n';
	//IAPʼʼַ
	i=IAP_ReadPPage(IAPLB_P);
    printf("\nRead IAPLB:%02bX",i);

	// IAPʼַΪ0x40,IAPռ
	IAP_WritePPage(IAPLB_P,0x40);
	i=IAP_ReadPPage(IAPLB_P);
    printf("\nNOW IAPLB:%02bX",i);
	TrapFlag[2]=0xFF;

	printf("\nOLD IAP:\n");
	i=0;
	do{
		LED_G_1=0;
		IAPData=IAP_ReadByteByMOVC(IAP_ADDRESS+i);	// MOVCķʽȡ
		LED_G_1=1;
		printf("%02bX ",IAPData);
		if((i&0x0F)==0x0F)
		{
			printf("\n");
		}
		i++;
	}while(i!=0);
    

    while(1)
    {
    	rand++;
		LED_G_0=!LED_G_0;
	   	DelayXms(100);
		if(P10==0)
		{
			DelayXms(50);
			if(P10==0)
			{
				TrapFlag[2]='n';
				
				// IAPʼַΪIAPַ
				IAP_WritePPage(IAPLB_P,IAP_ADDRESS/256);
				LED_R=0;
				// ҳ
				IAP_ErasePage(IAP_ADDRESS/256);
				LED_R=1;

				// д
				printf("\nWRITE IAP:\n");
				i=0;
				do{
					IAPData=rand+i;
					LED_G_1=0;
					IAP_WriteByte(IAP_ADDRESS+i,IAPData);
					LED_G_1=1;
					printf("%02bX ",IAPData);
					if((i&0x0F)==0x0F)
					{
						printf("\n");
					}
					i++;
				}while(i!=0);
				// IAPʼַΪ0x40,IAPռ
				IAP_WritePPage(IAPLB_P,0x40);
				
				TrapFlag[2]=0xFF;

				printf("\nNOW IAP:\n");
				i=0;
				bOK=TRUE;
				do{
					LED_G_1=0;
					IAPData=IAP_ReadByteByMOVC(IAP_ADDRESS+i);	// MOVCķʽȡ
					LED_G_1=1;
					printf("%02bX ",IAPData);
					if((i&0x0F)==0x0F)
					{
						printf("\n");
					}
					// ж϶Ƿдһ
					if(IAPData != (BYTE)(rand+i))
					{
						bOK=FALSE;
					}
					i++;
				}while(i!=0);
				LED_G_1=1;LED_R=1;
				if(bOK)
				{	// ͬ
					LED_G_1=0;
				}
				else
				{	// ݲͬ
					LED_R=0;
				}
				while(P10==0)
				{
					DelayXms(50);
				}
			}
		}
    }
}


