/*********************************************************************
    Project:MG82F6D17-DEMO
    Author:YZY
			MG82F6D17 SSOP20_V10 EV Board (TH194A)
			CpuCLK=12MHz, SysCLK=12MHz
	Description:
			set P44/P45 to GPIO, Disable OCD function
			set P47 to GPIO, Disable RESTET function
		Note:
			If P44,P45 and P47 are used for GPIO at the same time, OCD-ICE cannot be used for burning and simulation.
			To restore OCD function, it is necessary to use U1 burning the other code.

    Creat time::
    Modify::
    
*********************************************************************/
#include "MG82F6D17_CONFIG.h"

#define MCU_SYSCLK		12000000
#define MCU_CPUCLK		(MCU_SYSCLK)
#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35

/*************************************************
Function:     	void DelayXus(u16 xUs)
Description:   	dealyunit:us
Input:     			u8 Us -> *1us  (1~255)
Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
Function:     	void DelayXms(u16 xMs)
Description:    dealyunit:ms
Input:     			u16 xMs -> *1ms  (1~65535)
Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
	}
}

void main ()
{
	#warning ("Please notice that you won't be able to use OCD ICE but U1 Writer to update new programme if you set both P44P45P47 to GPIO mode")
  System_Init(); 
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

  while(1)
  {
		LED_G_0=0;P44=0;
		DelayXms(200);
		LED_G_0=1;P44=1;
		LED_G_1=0;P45=0;
		DelayXms(200);
		LED_G_1=1;P45=1;
		LED_R=0;P47=0;
		DelayXms(200);
		LED_R=1;P47=1;
  }
}
