/*********************************************************************
*Ŀ:MG82F6B08_001_104-DEMO
*			԰ʹ MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*
*			T2ΪMode3:ģʽԶ,ָģʽ
*ע
*
*ʱ:
*޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*ϵͳʱSysClk (MAX.24MHz)
*ѡ: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)


#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46

#define CAPTURE_BUF_SIZE	8
bit bT2Capture;
xdata u8 T2CaptureData[CAPTURE_BUF_SIZE];
u8 T2CaptureCnt;


/***********************************************************************************
*:   void INT_T2(void)
*:T2 жϷ
*:   
*ز:     
*************************************************************************************/
void INT_T2(void) interrupt INT_VECTOR_T2
{
	if(TF2)
	{
		LED_R=!LED_R;
		TF2=0;
	}
	if(EXF2)
	{
		EXF2=0;
		if(bT2Capture==0)
		{
			T2CaptureData[T2CaptureCnt]=RCAP2H;
			T2CaptureCnt++;
			if(T2CaptureCnt>=CAPTURE_BUF_SIZE)
			{
				bT2Capture=TRUE;
			}
		}
	}
	if(TF2L)
	{
		LED_G_1=!LED_G_1;
		TF2L=0;
	}
}

/***********************************************************************************

/*************************************************
*:     void DelayXus(u8 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:void SendByte(u8 tByte)
*:0
*: u8 tByte: ͵
*ز:     
*************************************************************************************/
void SendByte(u8 tByte)
{
	bit bES0;
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}



/***********************************************************************************
*:void SendStr(u8* PStr)
*:ַ
*: u8* PStr:ַʼַ
*ز:     
*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
*:   void SendHex(u8 ToSend)
*:ַʽ16
*: u8 ToSend: ͵16  
*ز:     
*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
//	SendByte(' ');
//	SendByte('0');
//	SendByte('x');
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/***********************************************************************************
*:   void InitTimer2(void)
*:Timer2ʼ	
*:   
*ز:     
*************************************************************************************/
void InitTimer2(void)
{
	TM_SetT2Mode_CapturewithAutoZero();		// T2ģʽ2Ϊλģʽ Զ
	TM_SetT2Clock_SYSCLKDiv12();			// T2ʱԴΪ SYSCLK/12
	TM_SetTL2Clock_SYSCLKDiv12();			// T2LʱԴΪ SYSCLK/12
	TM_EnableAccessTF2L();					// ʹܷTF2LTF2Lж
	TM_DisableTR2LC();						// TR2LCԷֹTH2ʱTL2
	TM_EnT2Split();							// ʹT2ָģʽ
	
	TM_SetT2LowByte(0);						// T28λ				
	TM_SetT2RLLowByte(0);				    // ֵ8λ		  ---T2LƵΪ SYSCLK/12/(256-0)

	TM_SetT2HighByte(0x40);					// T28λ
	TM_SetT2RLHighByte(0x40);				// ֵ8λ

	TM_SetT2Capture_T2EXPin();				// ʹT2ⲿжΪT2EX
	TM_SetT2CKOT2EX_P31P30();				// ʹT2EXΪP30
	TM_EnableT2EX_DetectFalling();			// ʹT2EXż½

	TM_EnableT2();							// ʹT2
	TM_EnableTL2();							// ʹTL2
}


/***********************************************************************************
*:   void InitInterrupt(void)
*:InitInterruptʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER2();
	INT_EnTIMER2L();						// ʹTF2Lж
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		//  P30,P31,P32,P33Ϊ˫,RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				//  P46Ϊ©,LED
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45  MCK/4
	//CLK_P45OC_MCKDiv4();
}


/***********************************************************************************
*:   void InitUart0_S0BRG(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
}



/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitClock();
	InitUart0_S0BRG();
	
	InitTimer2();			

	InitInterrupt();		// жϳʼ
	
	INT_EnAll();			// ʹȫж

}



void main()
{
	
	u8 i;
	
    InitSystem();
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
    	DelayXms(100);
    	if(bT2Capture)
    	{
			SendStr("\nT2 Caputre:");
			for(i=0;i<CAPTURE_BUF_SIZE;i++)
			{
				SendByte('0');
				SendByte('x');
				SendHex(T2CaptureData[i]);
				SendByte(' ');
			}
			T2CaptureCnt=0;
			bT2Capture=0;
    	}
    }
}


