#include "stdafx.h"
#include "Version.h"

#pragma comment(lib, "Version.lib")

// The version of the application
VERSIONINFO ApVersionInfo;
//-----------------------------------------------------------------------------
// Function Name : GetCurrentVersionInfo
// Input         : pApVersionInfo, the pointer to ApVersionInfo
//                 
// Return        : dwResult
//-----------------------------------------------------------------------------
// Description   : Get the verison number of the application itself
//                 
//-----------------------------------------------------------------------------
DWORD GetCurrentVersionInfo(VERSIONINFO * pApVersionInfo)
{
    DWORD dwResult = ERROR_SUCCESS;
    TCHAR subBlock[] = _T("\\");
    VS_FIXEDFILEINFO * pFixedFileInfo = NULL;
    BOOL bResult = 0;
    UINT dwLength = 0;

    memset(pApVersionInfo, 0, sizeof(*pApVersionInfo));
    HRSRC hRes = FindResource(AfxGetApp()->m_hInstance, MAKEINTRESOURCE(VS_VERSION_INFO), RT_VERSION);
    if (hRes != NULL)
    {
        HGLOBAL hResLoad = LoadResource(AfxGetApp()->m_hInstance, hRes);
        if (hResLoad != NULL)
        {
            BYTE *lpResLock = (BYTE*)LockResource(hResLoad);
            if (lpResLock != NULL)
            {
                bResult = VerQueryValue(lpResLock, subBlock, (VOID**)&pFixedFileInfo, &dwLength);
                if ((bResult != 0) && (pFixedFileInfo != NULL, dwLength > 0))
                {
                    pApVersionInfo->dwMajorVersion = (pFixedFileInfo->dwProductVersionMS >> 16) & 0xFF;
                    pApVersionInfo->dwMinorVersion = pFixedFileInfo->dwProductVersionMS & 0xFF;
                    pApVersionInfo->dwPatchVersion = (pFixedFileInfo->dwProductVersionLS >> 16) & 0xFF;
                    pApVersionInfo->dwCustomVersion = pFixedFileInfo->dwProductVersionLS & 0xFF;
                }
            }
        }
        else
        {
            dwResult = GetLastError();
        }
    }
    else
    {
        dwResult = GetLastError();
    }
    return dwResult;
}

