#include "delay.h"
#include "MG32x02z_DRV.H"
////////////////////////////////////////////////////////////////////////////////// 	 
//ʹOS,t^ļucos.
#if SYSTEM_SUPPORT_OS
#include "includes.h"					//֧OSrʹ	  
#endif
//////////////////////////////////////////////////////////////////////////////////  
//ֻWʹãδSɣκ;
//ALIENTEK STM32F407_l
//ʹSysTickͨӋģʽtMй(֧OS)
//delay_us,delay_ms
//cԭ@ALIENTEK
//gՓ:www.openedv.com
//:2014/5/2
//汾V1.3
//УIؾ
//Copyright(C) VӿƼ޹˾ 2014-2024
//All rights reserved
//********************************************************************************
//޸f
//V1.1 20140803 
//1,delay_us,Ӆ0Д,0,tֱ˳. 
//2,޸ucosii,delay_ms,OSLockNestingД,MД,ҲԜʴ_ӕr.
//V1.2 20150411  
//޸OSַ֧ʽ,֧OS(UCOSIIUCOSIII,ՓOS֧)
//:delay_osrunning/delay_ostickspersec/delay_osintnesting궨x
//:delay_osschedlock/delay_osschedunlock/delay_ostimedly
//V1.3 20150521
//UCOSIII֧֕r2bug
//delay_tickspersecĞ飺delay_ostickspersec
//delay_intnestingĞ飺delay_osintnesting
////////////////////////////////////////////////////////////////////////////////// 

static uint8_t  fac_us=0;							//usӕr˔			   
static uint16_t fac_ms=0;							//msӕr˔,os,ÿĵms
	
#if SYSTEM_SUPPORT_OS							//SYSTEM_SUPPORT_OSx,fҪ֧OS(UCOS).
//delay_us/delay_msҪ֧OSĕrҪcOSPĺ궨xͺ֧
//3궨x:
//    delay_osrunning:춱ʾOSǰǷ\,ԛQǷʹP
//delay_ostickspersec:춱ʾOSOĕr犹,delay_init@ʼsystick
// delay_osintnesting:춱ʾOSДǶ׼e,ДY治{,delay_msʹԓQ\
//Ȼ3:
//  delay_osschedlock:iOS΄{,ֹ{
//delay_osschedunlock:춽iOS΄{,_{
//    delay_ostimedly:OSӕr,΄{.

//̃HUCOSIIUCOSIII֧,OS,ՈЅֲ
//֧UCOSII
#ifdef 	OS_CRITICAL_METHOD						//OS_CRITICAL_METHODx,fҪ֧UCOSII				
#define delay_osrunning		OSRunning			//OSǷ\Иӛ,0,\;1,\
#define delay_ostickspersec	OS_TICKS_PER_SEC	//OSr犹,ÿ{ȴΔ
#define delay_osintnesting 	OSIntNesting		//ДǶ׼e,ДǶ״Δ
#endif

//֧UCOSIII
#ifdef 	CPU_CFG_CRITICAL_METHOD					//CPU_CFG_CRITICAL_METHODx,fҪ֧UCOSIII	
#define delay_osrunning		OSRunning			//OSǷ\Иӛ,0,\;1,\
#define delay_ostickspersec	OSCfg_TickRate_Hz	//OSr犹,ÿ{ȴΔ
#define delay_osintnesting 	OSIntNestingCtr		//ДǶ׼e,ДǶ״Δ
#endif


//usӕrr,P]΄{(ֹust)
void delay_osschedlock(void)
{
#ifdef CPU_CFG_CRITICAL_METHOD   			//ʹUCOSIII
	OS_ERR err; 
	OSSchedLock(&err);						//UCOSIIIķʽ,ֹ{ȣֹusӕr
#else										//tUCOSII
	OSSchedLock();							//UCOSIIķʽ,ֹ{ȣֹusӕr
#endif
}

//usӕrr,ָ΄{
void delay_osschedunlock(void)
{	
#ifdef CPU_CFG_CRITICAL_METHOD   			//ʹUCOSIII
	OS_ERR err; 
	OSSchedUnlock(&err);					//UCOSIIIķʽ,ָ{
#else										//tUCOSII
	OSSchedUnlock();						//UCOSIIķʽ,ָ{
#endif
}

//{OSԎӕrӕr
//ticks:ӕrĹĔ
void delay_ostimedly(uint32_t ticks)
{
#ifdef CPU_CFG_CRITICAL_METHOD
	OS_ERR err; 
	OSTimeDly(ticks,OS_OPT_TIME_PERIODIC,&err);//UCOSIIIӕrģʽ
#else
	OSTimeDly(ticks);						//UCOSIIӕr
#endif 
}
 
//systickДպ,ʹOSrõ
void SysTick_Handler(void)
{	
	if(delay_osrunning==1)					//OS_ʼ,ň{̎
	{
		OSIntEnter();						//MД
		OSTimeTick();       				//{ucosĕr犷ճ               
		OSIntExit();       	 				//|l΄ГQܛД
	}
}
#endif
			   
//ʼt
//ʹOSĕr,˺ʼOSĕr犹
//SYSTICKĕr犹̶AHBr犵1/8
//SYSCLK:ϵyrl
void delay_init(uint8_t SYSCLK)
{
#if SYSTEM_SUPPORT_OS 						//Ҫ֧OS.
	uint32_t reload;
#endif
 	SysTick_CLKSourceConfig(SysTick_CLKSource_HCLK_Div8); 
	fac_us=SYSCLK/8;						//ՓǷʹOS,fac_usҪʹ
#if SYSTEM_SUPPORT_OS 						//Ҫ֧OS.
	reload=SYSCLK/8;						//ÿ犵ӋΔ λM	   
	reload*=1000000/delay_ostickspersec;	//delay_ostickspersecOrg
											//reload24λĴ,ֵ:16777216,168M,s0.7989s	
	fac_ms=1000/delay_ostickspersec;		//OSӕrنλ	   
	SysTick->CTRL|=SysTick_CTRL_TICKINT_Msk;   	//_SYSTICKД
	SysTick->LOAD=reload; 					//ÿ1/delay_ostickspersecДһ	
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk; 	//_SYSTICK    
#else
	fac_ms=(uint16_t)fac_us*1000;				//OS,ÿmsҪsystickr犔   
#endif
}								    

#if SYSTEM_SUPPORT_OS 						//Ҫ֧OS.
//ӕrnus
//nus:Ҫӕrus.	
//nus:0~204522252(ֵ2^32/fac_us@fac_us=21)	    								   
void delay_us(uint32_t nus)
{		
	uint32_t ticks;
	uint32_t told,tnow,tcnt=0;
	uint32_t reload=SysTick->LOAD;				//LOADֵ	    	 
	ticks=nus*fac_us; 						//ҪĹĔ 
	delay_osschedlock();					//ֹOS{ȣֹusӕr
	told=SysTick->VAL;        				//MrӋֵ
	while(1)
	{
		tnow=SysTick->VAL;	
		if(tnow!=told)
		{	    
			if(tnow<told)tcnt+=told-tnow;	//@Y]һSYSTICKһfpӋͿ.
			else tcnt+=reload-tnow+told;	    
			told=tnow;
			if(tcnt>=ticks)break;			//rg^/Ҫtĕrg,t˳.
		}  
	};
	delay_osschedunlock();					//ָOS{											    
}  
//ӕrnms
//nms:Ҫӕrms
//nms:0~65535
void delay_ms(uint16_t nms)
{	
	if(delay_osrunning&&delay_osintnesting==0)//OSѽ,KҲДY(ДY治΄{)	    
	{		 
		if(nms>=fac_ms)						//ӕrĕrgOSٕrg 
		{ 
   			delay_ostimedly(nms/fac_ms);	//OSӕr
		}
		nms%=fac_ms;						//OSѽoṩ@Сӕr,ͨʽӕr    
	}
	delay_us((uint32_t)(nms*1000));				//ͨʽӕr
}
#else  //ucosr
//ӕrnus
//nusҪӕrus.	
//]:nusֵ,Ҫ798915us(ֵ2^24/fac_us@fac_us=21)
void delay_us(uint32_t nus)
{		
	uint32_t temp;	    	 
	SysTick->LOAD=nus*fac_us; 				//rgd	  		 
	SysTick->VAL=0x00;        				//Ӌ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ; //_ʼ 	 
	do
	{
		temp=SysTick->CTRL;
	}while((temp&0x01)&&!(temp&(1<<16)));	//ȴrg_   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk; //P]Ӌ
	SysTick->VAL =0X00;       				//Ӌ 
}
//ӕrnms
//]nmsĹ
//SysTick->LOAD24λĴ,,ӕr:
//nms<=0xffffff*8*1000/SYSCLK
//SYSCLKλHz,nmsλms
//168Ml,nms<=798ms 
void delay_xms(uint16_t nms)
{	 		  	  
	uint32_t temp;		   
	SysTick->LOAD=(uint32_t)nms*fac_ms;			//rgd(SysTick->LOAD24bit)
	SysTick->VAL =0x00;           			//Ӌ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //_ʼ 
	do
	{
		temp=SysTick->CTRL;
	}while((temp&0x01)&&!(temp&(1<<16)));	//ȴrg_   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //P]Ӌ
	SysTick->VAL =0X00;     		  		//Ӌ	  	    
} 
//ӕrnms 
//nms:0~65535
void delay_ms(uint16_t nms)
{	 	 
	uint8_t repeat=nms/540;						//@Y540,ǿ]ĳЩ͑ܳlʹ,
											//糬l248Mĕr,delay_xmsֻӕr541ms
	uint16_t remain=nms%540;
	while(repeat)
	{
		delay_xms(540);
		repeat--;
	}
	if(remain)delay_xms(remain);
} 
#endif
			 


