#ifndef _USERDEFINE_H

#define _USERDEFINE_H

#define DMA_SRAM_START_ADDRESS		0x20003800
#define DMA_SRAM_END_ADDRESS		0x20003FFF

/*! @enum   PINX_AF_TypeDef
    @brief  Pin IO AF control options .
*/ 
typedef enum
{
	// PORTA AF 	
	PA0_AF_GPA0				=	0,
	PA1_AF_GPA1				=	0,
	PA2_AF_GPA2				=	0,
	PA3_AF_GPA3				=	0,
	PA4_AF_GPA4				=	0,
	PA5_AF_GPA5				=	0,
	PA6_AF_GPA6				=	0,
	PA7_AF_GPA7				=	0,
	PA8_AF_GPA8				=	0,
	PA9_AF_GPA9				=	0,
	PA10_AF_GPA10			=	0,
	PA11_AF_GPA11			=	0,
	PA12_AF_GPA12			=	0,
	PA13_AF_GPA13			=	0,
	PA14_AF_GPA14			=	0,
	PA15_AF_GPA15			=	0,
	
	PA0_AF_MA0				=	8,
	PA1_AF_MA1				=	8,
	PA2_AF_MA2				=	8,
	PA3_AF_MA3				=	8,
	PA4_AF_MA4				=	8,
	PA5_AF_MA5				=	8,
	PA6_AF_MA6				=	8,
	PA7_AF_MA7				=	8,
	PA8_AF_MA8				=	8,
	PA9_AF_MA9				=	8,
	PA10_AF_MA10			=	8,
	PA11_AF_MA11			=	8,
	PA12_AF_MA12			=	8,
	PA13_AF_MA13			=	8,
	PA14_AF_MA14			=	8,
	PA15_AF_MA15			=	8,
	
	// PORTB AF 	
	PB0_AF_GPB0				=	0,
	PB1_AF_GPB1				=	0,
	PB2_AF_GPB2				=	0,
	PB3_AF_GPB3				=	0,
	PB4_AF_GPB4				=	0,
	PB5_AF_GPB5				=	0,
	PB6_AF_GPB6				=	0,
	PB7_AF_GPB7				=	0,
	PB8_AF_GPB8				=	0,
	PB9_AF_GPB9				=	0,
	PB10_AF_GPB10			=	0,
	PB11_AF_GPB11			=	0,
	PB12_AF_GPB12			=	0,
	PB13_AF_GPB13			=	0,
	PB14_AF_GPB14			=	0,
	PB15_AF_GPB15			=	0,
	
	PB0_AF_I2C1_SCL			=	1,
	PB1_AF_I2C1_SDA			=	1,
	PB2_AF_ADC0_TRG			=	1,
	PB3_AF_ADC0_OUT			=	1,
	PB4_AF_TM01_CKO			=	1,
	PB5_AF_TM16_CKO			=	1,
	PB6_AF_CPU_RXEV			=	1,
	PB7_AF_CPU_TXEV			=	1,
	PB8_AF_CMP0_P0			=	1,
	PB9_AF_CMP1_P0			=	1,
	PB10_AF_CMP2_P0			=	1,
	PB11_AF_CMP3_P0			=	1,
	PB12_AF_DMA_TRG0		=	1,
	PB13_AF_DAC_TRG0		=	1,
	PB15_AF_IR_OUT			=	1,
	
	PB0_AF_SPI0_NSS				=	2,
	PB1_AF_SPI0_MISO			=	2,
	PB2_AF_SPI0_CLK				=	2,
	PB3_AF_SPI0_MOSI			=	2,
	PB4_AF_SPI0_D3				=	2,
	PB5_AF_SPI0_D2				=	2,
	PB6_AF_SPI0_NSSI			=	2,
	PB8_AF_RTC_OUT				=	2,
	PB9_AF_RTC_TS				=	2,
	PB10_AF_I2C0_SCL			=	2,
	PB11_AF_I2C0_SDA			=	2,
	PB13_AF_TM00_ETR			=	2,
	PB14_AF_TM00_TRGO			=	2,
	
	PB0_AF_TM01_ETR				=	3,
	PB1_AF_TM01_TRGO			=	3,
	PB2_AF_TM01_CKO				=	3,
	PB4_AF_TM26_TRGO			=	3,
	PB5_AF_TM26_ETR				=	3,
	PB6_AF_URT0_BRO				=	3,
	PB7_AF_URT0_TMO				=	3,
	PB8_AF_URT0_TX				=	3,
	PB9_AF_URT0_RX				=	3,
	PB10_AF_URT0_NSS			=	3,
	PB11_AF_URT0_DE				=	3,
	PB13_AF_URT0_CTS			=	3,
	PB14_AF_URT0_RTS			=	3,
	
	PB0_AF_TM00_CKO				=	4,
	PB1_AF_TM10_CKO				=	4,
	PB2_AF_URT2_TX				=	4,
	PB3_AF_URT2_RX				=	4,
	PB4_AF_URT2_CLK				=	4,
	PB5_AF_URT2_NSS				=	4,
	PB6_AF_URT2_CTS				=	4,
	PB7_AF_URT2_RTS				=	4,
	PB8_AF_URT2_BRO				=	4,
	PB9_AF_URT2_TMO				=	4,
	PB10_AF_URT2_DE				=	4,
	PB13_AF_URT3_RX				=	4,
	PB14_AF_URT3_TX				=	4,
	
	PB0_AF_TM16_ETR				=	5,
	PB1_AF_TM16_TRGO			=	5,
	PB2_AF_TM16_CKO				=	5,
	PB4_AF_TM20_IC0				=	5,
	PB5_AF_TM20_IC1				=	5,
	PB6_AF_TM20_ETR				=	5,
	PB7_AF_TM20_TRGO			=	5,
	PB8_AF_TM20_OC01			=	5,
	PB9_AF_TM20_OC02			=	5,
	PB10_AF_TM20_OC11			=	5,
	PB11_AF_TM20_OC12			=	5,
	PB13_AF_TME20_ETR			=	5,
	PB14_AF_TM20_TRGO			=	5,
	
	PB0_AF_TM26_IC0				=	6,
	PB1_AF_TM26_IC1				=	6,
	PB2_AF_TM26_OC0H			=	6,
	PB3_AF_TM26_OC1H			=	6,
	PB4_AF_TM36_IC0				=	6,
	PB5_AF_TM36_IC1				=	6,
	PB6_AF_TM36_IC2				=	6,
	PB7_AF_TM36_IC3				=	6,
	PB8_AF_TM36_OC01			=	6,
	PB9_AF_TM36_OC02			=	6,
	PB10_AF_TM36_OC11			=	6,
	PB11_AF_TM36_OC12			=	6,
	PB13_AF_TM36_ETR			=	6,
	PB14_AF_TM36_BK				=	6,
	
	PB0_AF_MA15				=	8,
	PB4_AF_MALE				=	8,
	PB5_AF_MOE				=	8,
	PB6_AF_MWE				=	8,
	PB7_AF_MCE				=	8,
	PB8_AF_MAD0				=	8,
	PB9_AF_MAD1				=	8,
	PB10_AF_MAD2			=	8,
	PB11_AF_MAD3			=	8,
	PB12_AF_MAD4			=	8,
	PB13_AF_MAD5			=	8,
	PB14_AF_MAD6			=	8,
	PB15_AF_MAD7			=	8,
	
	PB4_AF_MAD8				=	9,
	PB5_AF_MAD9				=	9,
	PB6_AF_MAD10			=	9,
	PB7_AF_MALE2			=	9,
	PB9_AF_MAD8				=	9,
	PB10_AF_MAD1			=	9,
	PB11_AF_MAD9			=	9,
	PB12_AF_MAD2			=	9,
	PB13_AF_MAD10			=	9,
	PB14_AF_MAD3			=	9,
	PB15_AF_MAD11			=	9,
	
	// PORTC AF 	
	PC0_AF_GPC0				=	0,
	PC1_AF_GPC1				=	0,
	PC2_AF_GPC2				=	0,
	PC3_AF_GPC3				=	0,
	PC4_AF_GPC4				=	0,
	PC5_AF_GPC5				=	0,
	PC6_AF_GPC6				=	0,
	PC7_AF_GPC7				=	0,
	PC8_AF_GPC8				=	0,
	PC9_AF_GPC9				=	0,
	PC10_AF_GPC10			=	0,
	PC11_AF_GPC11			=	0,
	PC12_AF_GPC12			=	0,
	PC13_AF_GPC13			=	0,
	PC14_AF_GPC14			=	0,
	PC15_AF_GPC15			=	0,
	
	PC0_AF_ICKO			=	1,
	PC1_AF_ADC0_TRG		=	1,
	PC2_AF_ADC0_OUT		=	1,
	PC3_AF_OBM_P1		=	1,
	PC4_AF_SWCLK		=	1,
	PC5_AF_SWDIO		=	1,
	PC6_AF_RSTN			=	1,
	PC7_AF_ADC0_TRG		=	1,
	PC8_AF_ADC0_OUT		=	1,
	PC9_AF_CMP0_P0		=	1,
	PC10_AF_CMP1_P0		=	1,
	PC11_AF_CMP2_P0		=	1,
	PC12_AF_CMP3_P0		=	1,
	PC13_AF_XIN			=	1,
	PC14_AF_XOUT		=	1,
	
	PC0_AF_TM00_CKO				=	2,
	PC1_AF_TM01_CKO				=	2,
	PC2_AF_TM10_CKO				=	2,
	PC3_AF_TM16_CKO				=	2,
	PC4_AF_I2C0_SCL				=	2,
	PC5_AF_I2C0_SDA				=	2,
	PC6_AF_RTC_TS				=	2,
	PC7_AF_RTC_OUT				=	2,
	PC8_AF_I2C0_SCL				=	2,
	PC9_AF_I2C0_SDA				=	2,
	PC10_AF_I2C1_SCL			=	2,
	PC11_AF_I2C_SDA				=	2,
	PC12_AF_IR_OUT				=	2,

	PC0_AF_URT0_CLK				=	3,
	PC2_AF_OBM_P0				=	3,
	PC3_AF_URT0_CLK				=	3,
	PC4_AF_URT0_RX				=	3,
	PC5_AF_URT0_TX				=	3,
	PC6_AF_URT0_NSS				=	3,
	PC7_AF_URT0_DE				=	3,
	PC8_AF_URT0_BRO				=	3,
	PC9_AF_URT0_TMO				=	3,
	PC10_AF_URT0_TX				=	3,
	PC11_AF_URT0_RX				=	3,
	PC12_AF_DAC_TRG0			=	3,
	PC13_AF_URT0_CTS			=	3,
	PC14_AF_URT0_RTS			=	3,
	
	PC0_AF_URT2_CLK				=	4,
	PC1_AF_URT1_CLK				=	4,
	PC2_AF_URT2_CLK				=	4,
	PC3_AF_URT1_CLK				=	4,
	PC4_AF_URT1_RX				=	4,
	PC5_AF_URT1_TX				=	4,
	PC8_AF_URT1_TX				=	4,
	PC9_AF_URT1_RX				=	4,
	PC10_AF_URT2_TX				=	4,
	PC11_AF_URT2_RX				=	4,
	PC13_AF_URT2_RX				=	4,
	PC14_AF_URT2_TX				=	4,

	PC0_AF_TM20_OC00				=	5,
	PC1_AF_TM20_OC0N				=	5,
	PC2_AF_TM20_OC10				=	5,
	PC3_AF_TM20_OC1N				=	5,
	PC6_AF_TM20_ETR					=	5,
	PC8_AF_TM20_OC0H				=	5,
	PC9_AF_TM20_OC1H				=	5,
	PC12_AF_TM10_TRGO				=	5,
	PC13_AF_TM10_ETR				=	5,
	PC14_AF_TM10_CKO				=	5,

	PC0_AF_TM36_OC00				=	6,
	PC1_AF_TM36_OC0N				=	6,
	PC2_AF_TM36_OC10				=	6,
	PC3_AF_TM36_OC1N				=	6,
	PC6_AF_TM26_ETR					=	6,
	PC7_AF_TM36_TRGO				=	6,
	PC8_AF_TM36_OC0H				=	6,
	PC9_AF_TM36_OC1H				=	6,
	PC10_AF_TM36_OC2H				=	6,
	PC11_AF_TM36_OC3H				=	6,
	PC12_AF_TM36_OC3				=	6,
	PC13_AF_TM26_ETR				=	6,
	PC14_AF_TM26_TRGO				=	6,

	PC0_AF_MCLK				=	8,
	PC1_AF_MAD8				=	8,
	PC2_AF_MAD9				=	8,
	PC3_AF_MAD10			=	8,
	PC6_AF_MBW1				=	8,
	PC7_AF_MBW0				=	8,
	PC8_AF_MAD11			=	8,
	PC9_AF_MAD12			=	8,
	PC10_AF_MAD13			=	8,
	PC11_AF_MAD14			=	8,
	PC12_AF_MAD15			=	8,

	PC0_AF_MWE				=	9,
	PC1_AF_MAD4				=	9,
	PC2_AF_MAD12			=	9,
	PC3_AF_MAD5				=	9,
	PC6_AF_MALE				=	9,
	PC7_AF_MCE				=	9,
	PC8_AF_MAD13			=	9,
	PC9_AF_MAD6				=	9,
	PC10_AF_MAD14			=	9,
	PC11_AF_MAD7			=	9,
	
	
	// PORTD AF 	
	PD0_AF_GPD0				=	0,
	PD1_AF_GPD1				=	0,
	PD2_AF_GPD2				=	0,
	PD3_AF_GPD3				=	0,
	PD4_AF_GPD4				=	0,
	PD5_AF_GPD5				=	0,
	PD6_AF_GPD6				=	0,
	PD7_AF_GPD7				=	0,
	PD8_AF_GPD8				=	0,
	PD9_AF_GPD9				=	0,
	PD10_AF_GPD10			=	0,
	PD11_AF_GPD11			=	0,
	PD12_AF_GPD12			=	0,
	PD13_AF_GPD13			=	0,
	PD14_AF_GPD14			=	0,
	PD15_AF_GPD15			=	0,
	
	PD0_AF_OBM_I0		=	1,
	PD1_AF_OBM_I1		=	1,
	PD4_AF_TM00_TRGO	=	1,
	PD5_AF_TM00_ETR		=	1,
	PD6_AF_CPU_NMI		=	1,
	PD7_AF_TM00_CKO		=	1,
	PD11_AF_CPU_NMI		=	1,
	PD12_AF_CMP0_P0		=	1,
	PD13_AF_CMP1_P0		=	1,
	PD14_AF_CMP2_P0		=	1,
	PD15_AF_CMP3_P0		=	1,

	PD0_AF_TM10_CKO				=	2,
	PD1_AF_TM16_CKO				=	2,
	PD2_AF_TM00_CKO				=	2,
	PD3_AF_TM01_CKO				=	2,
	PD4_AF_TM01_TRGO			=	2,
	PD5_AF_I2C0_SCL				=	2,
	PD6_AF_I2C0_SDA				=	2,
	PD7_AF_TM01_ETR				=	2,
	PD8_AF_I2C1_SCL				=	2,
	PD9_AF_I2C1_SDA				=	2,
	PD11_AF_DMA_TRG1			=	2,
	PD12_AF_TM10_CKO			=	2,
	PD13_AF_TM10_TRGO			=	2,
	PD14_AF_TM10_ETR			=	2,

	PD0_AF_URT0_CLK				=	3,
	PD1_AF_URT0_CLK				=	3,
	PD2_AF_URT1_CLK				=	3,
	PD3_AF_URT1_CLK				=	3,
	PD4_AF_URT1_TX				=	3,
	PD5_AF_URT1_RX				=	3,
	PD6_AF_URT1_NSS				=	3,
	PD7_AF_URT1_DE				=	3,
	PD8_AF_URT1_RTS				=	3,
	PD9_AF_URT1_CTS				=	3,
	PD10_AF_URT1_BRO			=	3,
	PD11_AF_URT1_TMO			=	3,
	PD12_AF_OBM_P0				=	3,
	PD13_AF_OBM_P1				=	3,
	PD14_AF_DAC_TRG0			=	3,
	PD15_AF_IR_OUT				=	3,

	PD2_AF_TM26_OC00			=	4,
	PD3_AF_URT3_CLK				=	4,
	PD4_AF_URT3_RTS				=	4,
	PD5_AF_URT3_CTS				=	4,
	PD6_AF_URT3_DE				=	4,
	PD7_AF_URT3_NSS				=	4,
	PD8_AF_URT3_TX				=	4,
	PD9_AF_URT3_RX				=	4,
	PD10_AF_URT3_BRO			=	4,
	PD11_AF_URT3_TMO			=	4,
	PD12_AF_TM00_CKO			=	4,
	PD13_AF_TM00_TRGO			=	4,
	PD14_AF_TM00_ETR			=	4,
	PD15_AF_DMA_TRG0			=	4,

	PD0_AF_TM20_CKO				=	5,
	PD1_AF_TM26_CKO				=	5,
	PD2_AF_TM20_CKO				=	5,
	PD3_AF_SPI0_CLK				=	5,
	PD4_AF_SPI0_D3				=	5,
	PD5_AF_SPI0_D2				=	5,
	PD6_AF_SPI0_NSSi			=	5,
	PD7_AF_SPI0_MISO			=	5,
	PD8_AF_SPI0_NSS				=	5,
	PD10_AF_SPI0_MOSI			=	5,
	PD12_AF_SPI0_CLK			=	5,

	PD0_AF_TM36_OC2				=	6,
	PD1_AF_TM36_OC2N			=	6,
	PD2_AF_TM36_CKO				=	6,
	PD3_AF_TM26_CKO				=	6,
	PD4_AF_TM26_OC00			=	6,
	PD5_AF_TM26_OC01			=	6,
	PD6_AF_TM26_OC02			=	6,
	PD7_AF_TM26_OC0N			=	6,
	PD8_AF_TM26_OC10			=	6,
	PD9_AF_TM26_OC11			=	6,
	PD10_AF_TM26_OC12			=	6,
	PD11_AF_TM26_OC1N			=	6,
	PD12_AF_TM20_OC0H			=	6,
	PD13_AF_TM20_OC1H			=	6,
	PD14_AF_TM20_IC0			=	6,
	PD15_AF_TM20_IC1			=	6,

	PD1_AF_SPI0_CLK				=	7,
	PD2_AF_SPI0_MOSI			=	7,
	PD3_AF_SPI0_D3				=	7,
	PD4_AF_SPI0_D2				=	7,
	PD5_AF_SPI0_MISO			=	7,
	PD6_AF_SPI0_NSS				=	7,
	PD7_AF_SPI0_D4				=	7,
	PD8_AF_SPI0_D7				=	7,
	PD9_AF_SPI0_D6				=	7,
	PD10_AF_SPI0_D5				=	7,
	PD11_AF_SPI0_NSS			=	7,
	PD12_AF_TM26_OC0H			=	7,
	PD13_AF_TM26_OC1H			=	7,
	PD14_AF_TM26_IC0			=	7,
	PD15_AF_TM26_IC1			=	7,

	PD0_AF_MA0				=	8,
	PD1_AF_MA1				=	8,
	PD2_AF_MA2				=	8,
	PD3_AF_MA3				=	8,
	PD4_AF_MA4				=	8,
	PD5_AF_MA5				=	8,
	PD6_AF_MA6				=	8,
	PD7_AF_MA7				=	8,
	PD8_AF_MA8				=	8,
	PD9_AF_MA9				=	8,
	PD10_AF_MA10			=	8,
	PD11_AF_MA11			=	8,
	PD12_AF_MA12			=	8,
	PD13_AF_MA13			=	8,
	PD14_AF_MA14			=	8,
	PD15_AF_MA15			=	8,

	PD0_AF_MCLK				=	9,
	PD2_AF_MAD4				=	9,
	PD3_AF_MAD7				=	9,
	PD4_AF_MAD6				=	9,
	PD5_AF_MAD5				=	9,
	PD7_AF_MAD0				=	9,
	PD8_AF_MAD3				=	9,
	PD9_AF_MAD2				=	9,
	PD10_AF_MAD1			=	9,
	PD11_AF_MWE				=	9,
	PD12_AF_MALE2			=	9,
	PD13_AF_MCE				=	9,
	PD14_AF_MOE				=	9,
	
	// PORTE AF 	
	PE0_AF_GPE0				=	0,
	PE1_AF_GPE1				=	0,
	PE2_AF_GPE2				=	0,
	PE3_AF_GPE3				=	0,
	PE8_AF_GPE8				=	0,
	PE9_AF_GPE9				=	0,
	PE12_AF_GPE12			=	0,
	PE13_AF_GPE13			=	0,
	PE14_AF_GPE14			=	0,
	PE15_AF_GPE15			=	0,
	
	PE0_AF_OBM_I0			=	1,
	PE1_AF_OBM_I1			=	1,
	PE2_AF_OBM_P0			=	1,
	PE3_AF_OBM_P1			=	1,
	PE8_AF_CPU_TXEV			=	1,
	PE9_AF_CPU_RXEV			=	1,
	PE12_AF_ADC0_TRG		=	1,
	PE13_AF_ADC0_OUT		=	1,
	PE14_AF_RTC_OUT			=	1,
	PE15_AF_RTC_TS			=	1,

	PE0_AF_I2C0_SCL			=	2,
	PE1_AF_I2C0_SDA			=	2,
	PE2_AF_I2C1_SCL			=	2,
	PE3_AF_I2C1_SDA			=	2,
	PE8_AF_OBM_I0			=	2,
	PE9_AF_OBM_I1			=	2,
	PE14_AF_I2C1_SCL		=	2,
	PE15_AF_I2C1_SDA		=	2,

	PE0_AF_URT0_TX			=	3,
	PE1_AF_URT0_RX			=	3,
	PE2_AF_URT1_TX			=	3,
	PE3_AF_URT1_RX			=	3,
	PE8_AF_URT2_TX			=	3,
	PE9_AF_URT2_RX			=	3,
	PE12_AF_URT3_TX			=	3,
	PE13_AF_URT3_RX			=	3,

	PE1_AF_DMA_TRG1			=	4,
	PE12_AF_TM01_CKO		=	4,
	PE13_AF_TM01_TRGO		=	4,
	PE14_AF_TM01_ETR		=	4,

	PE0_AF_SPI0_NSS			=	5,
	PE1_AF_SPI0_MISO		=	5,
	PE2_AF_SPI0_MOSI		=	5,
	PE3_AF_SPI0_CLK			=	5,
	PE8_AF_TM36_CKO			=	5,
	PE9_AF_TM36_TRGO		=	5,
	PE12_AF_TM16_CKO		=	5,
	PE13_AF_TM16_TRGO		=	5,
	PE14_AF_TM16_ETR		=	5,
	PE15_AF_TM36_ETR		=	5,

	PE0_AF_TM20_OC00		=	6,
	PE1_AF_TM20_OC01		=	6,
	PE2_AF_TM20_OC02		=	6,
	PE3_AF_TM20_OC0N		=	6,
	PE8_AF_TM20_CKO			=	6,
	PE9_AF_TM20_TRGO		=	6,
	PE12_AF_TM20_OC10		=	6,
	PE13_AF_TM20_OC11		=	6,
	PE14_AF_TM20_OC12		=	6,
	PE15_AF_TM20_OC1N		=	6,

	PE0_AF_TM26_OC00		=	7,
	PE1_AF_TM26_OC01		=	7,
	PE2_AF_TM26_OC02		=	7,
	PE3_AF_TM26_OC0N		=	7,
	PE8_AF_TM26_CKO			=	7,
	PE9_AF_TM26_TRGO		=	7,
	PE12_AF_TM26_OC10   	=	7,
	PE13_AF_TM26_OC11   	=	7,
	PE14_AF_TM26_OC12   	=	7,
	PE15_AF_TM26_OC1N   	=	7,

	PE0_AF_MALE			=	8,
	PE1_AF_MOE			=	8,
	PE2_AF_MWE			=	8,
	PE3_AF_MCE			=	8,
	PE12_AF_MBW0		=	8,
	PE13_AF_MBW1		=	8,
	PE14_AF_MALE2		=	8,

	PE0_AF_MAD8			=	9,
	PE1_AF_MAD9			=	9,
	PE2_AF_MAD10		=	9,
	PE3_AF_MALE2		=	9,
	PE8_AF_MAD11		=	9,
	PE9_AF_MOE			=	9,
	PE15_AF_MALE		=	9,

}PINX_AF_TypeDef;


#endif
