

/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32x02z demo main c Code. 
 *
 * @par         Project
 *              MG32x02z
 * @version     
 * @date        
 * @author      
 * @copyright   
 *             
 *
 ******************************************************************************* 
 * @par Disclaimer

 *******************************************************************************
 */


#include "MG32x02z_DRV.H"
#include "Type.h"
#include "UserDefine.h"
#include "MG32x02z__Common_DRV.h"
#include "Stdio.h"			// for printf

#define _CK_IHRCO_		0
#define _CK_XOSC_		1
#define _CK_SEL_		_CK_IHRCO_

#define SYS_CLOCK	48.000				// sysclk =48MHz
#define PRINTF_URTX	URT3				// URT0 for printf

#define URT3_TX_PB14	0
#define URT3_TX_PD8		1				
#define URT3_TX_PE12	2

#define URT3_RX_PB13	0
#define URT3_RX_PD9		1				
#define URT3_RX_PE13	2

#define URT3_TX_USE		URT3_TX_PB14
#define URT3_RX_USE		URT3_RX_PB13


#define URT1_TX_PC8		0
#define URT1_TX_PC5		1				// Ź, URT0_TXDʱ,ܷ
#define URT1_TX_PD4		2
#define URT1_TX_PE2		3

#define URT1_RX_PC9		0
#define URT1_RX_PC4		1				// Ź, URT0_RXDʱ,ܷ
#define URT1_RX_PD5		2
#define URT1_RX_PE3		3

#define URT1_TX_USE		URT1_TX_PC8
#define URT1_RX_USE		URT1_RX_PC9


#define URT0_TX_PB8		0
#define URT0_TX_PC5		1				// Ź, URT0_TXDʱ,ܷ
#define URT0_TX_PC10	2
#define URT0_TX_PE0		3

#define URT0_RX_PB9		0
#define URT0_RX_PC4		1				// Ź, URT0_RXDʱ,ܷ
#define URT0_RX_PC11	2
#define URT0_RX_PE1		3

#define URT0_TX_USE		URT0_TX_PC10
#define URT0_RX_USE		URT0_RX_PC11

#define UART0_RX_BUF_SIZE		1048	//SOI+CID+LEN+ADDR+DATA+LRC+EOIDATA1024ֽĻ1048ֽڣСڵڸͨųȾ
#define UART3_RX_BUF_SIZE		1048
#define UARTX_RX_BUF_SIZE		1048	//Ϊ03



#define  SecetKeyLenth  8


u8 Uar0RxBuf[UART0_RX_BUF_SIZE];		//0ջ
u8 Uart0RxIn;							//0λ
u8 Uart0RxOut;							//0նȡλ

u8 Uar3RxBuf[UART3_RX_BUF_SIZE];		//3ջ
u8 Uart3RxIn;							//3λ
u8 Uart3RxOut;							//3նȡλ

u8 UarxRxBuf[UARTX_RX_BUF_SIZE];		//Эʹõʵʴڽջ
u8 UartxRxIn;							//Эʹõʵʴڽλ
u8 UartxRxOut;							//Эʹõʵʴڽնȡλ


u16 ISPTime =500;  					//500ms ISP
u8 ISPTimeCounting =1;				//ISPڵʱʹܣ1ʹ   			  0 
u8 WriteEnable =0;					//дʹ	1ʹ  			0
u8 ResetEnable =0;					//λʹܣ1ʹ  				0
u8 CheckOK =0;						//У֡У״̬1ʹ					  0
u16 BMSDCount =0;					//֡λֽڣ
u8 ProcUart =0;						//ЭдںŶ
u8 UartConfirm =0;					//жǷȷЭʹõĴ


u8 RxCID1;							//CID1֡
u8 TxCID1;							//CID1֡
u8 RxCID2;							//CID2֡
u8 TxCID2;							//CID2֡
u8 RxCID3;							//CID3֡
u8 TxCID3;							//CID3֡

WordTypeDef BMSRxLen;				//LEN֡
WordTypeDef BMSTxLen;				//LEN֡
WordTypeDef BMSRxADDR;				//ADDR֡
WordTypeDef BMSTxADDR;				//ADDR֡
u8 BMSRxData[1024]={0};				//DATA֡
u8 BMSTxData[1024]={0};				//DATA֡
WordTypeDef BMSLRCRxData;			//LRC֡
WordTypeDef BMSLRCTxData;			//LRC֡
u8 SecretKey[SecetKeyLenth]={ 0xAA,  0xA5,  0x5A,  0xA8,  0x8A,  0x58,  0x85,  0x78 };		//Կ



u8	SysStatus;		//ϵͳ״̬ö
enum{
	SYS_IDLE,
	SYS_WAIT_3A_2,
	SYS_WAIT_3A_3,
	SYS_WAIT_3A_4,
	SYS_WAIT_CID1,
	SYS_WAIT_CID2,
	SYS_WAIT_CID3,
	SYS_WAIT_LEN_H,
	SYS_WAIT_LEN_L,
	SYS_WAIT_ADDR_H,
	SYS_WAIT_ADDR_L,
	SYS_WAIT_DATA,
	SYS_WAIT_LRC_H,
	SYS_WAIT_LRC_L,
	SYS_WAIT_0D_1,
	SYS_WAIT_0D_2,
	SYS_WAIT_0D_3,
	SYS_WAIT_0D_4,
	SYS_CHECKSUM,
	SYS_HANDLE,
	SYS_SENDCMD

};

enum {
	DFU_ENTER = 0x88,
	DFU_DOWNLOAD = 0x80
};

u8 DFUCmd;
DWordTypeDef DFUAddr;
DWordTypeDef DFUSize;
WordTypeDef DFUDataChksum;
WordTypeDef DFUCmdChksum;
WordTypeDef DFUPageCnt;
u8 DFUData[64];
u8 DFUInx;

u8 OverTime;

u8 LedTime;
#define SetOverTime(x)	OverTime=x

#define FLASH_AP_STARTADDRESS	0x18000000
#define FLASH_AP_PAGE_CNT		100

/*
*************************************************************************************
* Interrupt Handler
*
*************************************************************************************
*/

/***********************************************************************************
:	void SysTick_Handler(void)
:	ϵͳTick жϴ
:	
ز:	  
*************************************************************************************/
void SysTick_Handler(void)
{
    //to do......
	IncTick();
	if(OverTime!=0) OverTime--;
	if(LedTime!=0) LedTime--;
	if(ISPTime!=0 && ISPTimeCounting ==1) ISPTime--;
}


 /***********************************************************************************
 :	 void URT0_IRQ(void)
 :	 URT0 жϴ
 :	 
 ز:	   
 *************************************************************************************/
 void URT0_IRQ(void)
 {
     uint32_t URT_Flag;
     uint32_t URT_IT_Msk;
     
     URT_Flag = URT_GetITAllFlagStatus(URT0);
     URT_IT_Msk = URT_GetITStatus(URT0);
     
     if((URT_Flag & URT_STA_UGF_mask_w) && (URT_IT_Msk & URT_INT_UG_IE_mask_w))
     {
        
         if((URT_Flag & URT_STA_SADRF_mask_w) && (URT_IT_Msk & URT_INT_SADR_IE_mask_w))
         {
             // To do ......
             
             URT_ClearITFlag(URT0,URT_IT_SADR);
         }
         if((URT_Flag & URT_STA_BRTF_mask_w) && (URT_IT_Msk & URT_INT_BRT_IE_mask_w))
         {
             // To do ......
             
             URT_ClearITFlag(URT0,URT_IT_BRT);
         }
         if((URT_Flag & URT_STA_TMOF_mask_w) && (URT_IT_Msk & URT_INT_TMO_IE_mask_w))
         {
             // To do ......
             
             URT_ClearITFlag(URT0,URT_IT_TMO);
         }
         URT_ClearITFlag(URT0,URT_IT_UG);
     }
     if((URT_Flag & URT_STA_RXF_mask_w) && (URT_IT_Msk & URT_INT_RX_IE_mask_w))
     {
         
         //---when RX Data Register have data---//
         
         // To do ......
         if(UartConfirm ==0)
		{
			Uar0RxBuf[Uart0RxIn] = URT_GetRXData(URT0);
         	UarxRxBuf[UartxRxIn] = Uar0RxBuf[Uart0RxIn];
         	if(Uar0RxBuf[Uart0RxIn] == ':')
         	{
				URT_ITEA_Cmd(URT3, DISABLE);
				//URT_Cmd(URT3,DISABLE);
				ProcUart = 0;
				UartConfirm =1;
	         }
	         Uart0RxIn++;
	         UartxRxIn++;
	         if(Uart0RxIn>= UART0_RX_BUF_SIZE)
	         {
				Uart0RxIn=0;	
	         }
	         if(UartxRxIn>= UARTX_RX_BUF_SIZE)
	         {
				UartxRxIn=0;	
	         }
		}
		else if(UartConfirm ==1)
		{
			UarxRxBuf[UartxRxIn] = URT_GetRXData(URT0);
			UartxRxIn++;
			if(UartxRxIn>= UARTX_RX_BUF_SIZE)
			{
			   UartxRxIn=0;    
			}
		}
         
         URT_ClearITFlag(URT0,URT_IT_RX);
     }
     if((URT_Flag & URT_STA_TXF_mask_w) && (URT_IT_Msk & URT_INT_TX_IE_mask_w))
     {
         // To do ......
         
         URT_ClearITFlag(URT0,URT_IT_TX);
     }
     if((URT_Flag & URT_STA_LSF_mask_w) && (URT_IT_Msk & URT_INT_LS_IE_mask_w))
     {
         if((URT_Flag & URT_STA_IDLF_mask_w) && (URT_IT_Msk & URT_INT_IDL_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT0,URT_IT_IDL);
         }
         if((URT_Flag & URT_STA_CTSF_mask_w) && (URT_IT_Msk & URT_INT_CTS_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT0,URT_IT_CTS);
         }
         URT_ClearITFlag(URT0,URT_IT_LS);
     }
     if((URT_Flag & URT_STA_ERRF_mask_w) && (URT_IT_Msk & URT_INT_ERR_IE_mask_w))
     {
         
         if((URT_Flag & URT_STA_PEF_mask_w) && (URT_IT_Msk & URT_INT_PE_IE_mask_w))
         {
             //To do......
            
             URT_ClearITFlag(URT0,URT_IT_PE);
         }
         if((URT_Flag & URT_STA_ROVRF_mask_w) && (URT_IT_Msk & URT_INT_ROVR_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT0,URT_IT_ROVR);
         }
         if((URT_Flag & URT_STA_RXTMOF_mask_w) && (URT_IT_Msk & URT_INT_RXTMO_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT0,URT_IT_RXTMO);
         }
         if((URT_Flag & URT_STA_IDTMOF_mask_w) && (URT_IT_Msk & URT_INT_IDTMO_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT0,URT_IT_IDTMO);
         }

     }
     if((URT_Flag & URT_STA_TCF_mask_w) && (URT_IT_Msk & URT_INT_TC_IE_mask_w))
     {
         //To do......
         
         URT_ClearITFlag(URT0, URT_IT_TC);
     }
}

/***********************************************************************************
:	void URT3_IRQ(void)
:	URT3 жϴ
:	
ز:	  
*************************************************************************************/
void URT3_IRQ(void)
 {
     uint32_t URT_Flag;
     uint32_t URT_IT_Msk;
     
     
     URT_Flag = URT_GetITAllFlagStatus(URT3);
     URT_IT_Msk = URT_GetITStatus(URT3);
     
     if((URT_Flag & URT_STA_UGF_mask_w) && (URT_IT_Msk & URT_INT_UG_IE_mask_w))
     {
        
         if((URT_Flag & URT_STA_SADRF_mask_w) && (URT_IT_Msk & URT_INT_SADR_IE_mask_w))
         {
             // To do ......
             
             URT_ClearITFlag(URT3,URT_IT_SADR);
         }
         if((URT_Flag & URT_STA_BRTF_mask_w) && (URT_IT_Msk & URT_INT_BRT_IE_mask_w))
         {
             // To do ......
             
             URT_ClearITFlag(URT3,URT_IT_BRT);
         }
         if((URT_Flag & URT_STA_TMOF_mask_w) && (URT_IT_Msk & URT_INT_TMO_IE_mask_w))
         {
             // To do ......
             
             URT_ClearITFlag(URT3,URT_IT_TMO);
         }
         URT_ClearITFlag(URT3,URT_IT_UG);
     }
     if((URT_Flag & URT_STA_RXF_mask_w) && (URT_IT_Msk & URT_INT_RX_IE_mask_w))
     {
		  if(UartConfirm ==0)
		 {
			 Uar3RxBuf[Uart3RxIn] = URT_GetRXData(URT3);
			 UarxRxBuf[UartxRxIn] = Uar3RxBuf[Uart3RxIn];
			 if(Uar3RxBuf[Uart3RxIn] == ':')
			 {
				 URT_ITEA_Cmd(URT0, DISABLE);
				 //URT_Cmd(URT0,DISABLE);
				 ProcUart = 3;
				 UartConfirm =1;
			  }
			  Uart3RxIn++;
			  UartxRxIn++;
			  if(Uart3RxIn>= UART3_RX_BUF_SIZE)
			  {
				 Uart3RxIn=0;	 
			  }
			  if(UartxRxIn>= UARTX_RX_BUF_SIZE)
			  {
				 UartxRxIn=0;	 
			  }
		 }
		 else if(UartConfirm ==1)
		 {
			 UarxRxBuf[UartxRxIn] = URT_GetRXData(URT3);
			 UartxRxIn++;
			 if(UartxRxIn>= UARTX_RX_BUF_SIZE)
			 {
				UartxRxIn=0;	
			 }
		 }
         
         URT_ClearITFlag(URT3,URT_IT_RX);

     }
     if((URT_Flag & URT_STA_TXF_mask_w) && (URT_IT_Msk & URT_INT_TX_IE_mask_w))
     {
         // To do ......
         
         URT_ClearITFlag(URT3,URT_IT_TX);
     }
     if((URT_Flag & URT_STA_LSF_mask_w) && (URT_IT_Msk & URT_INT_LS_IE_mask_w))
     {
         if((URT_Flag & URT_STA_IDLF_mask_w) && (URT_IT_Msk & URT_INT_IDL_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT3,URT_IT_IDL);
         }
         if((URT_Flag & URT_STA_CTSF_mask_w) && (URT_IT_Msk & URT_INT_CTS_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT3,URT_IT_CTS);
         }
         URT_ClearITFlag(URT3,URT_IT_LS);
     }
     if((URT_Flag & URT_STA_ERRF_mask_w) && (URT_IT_Msk & URT_INT_ERR_IE_mask_w))
     {
         
         if((URT_Flag & URT_STA_PEF_mask_w) && (URT_IT_Msk & URT_INT_PE_IE_mask_w))
         {
             //To do......
            
             URT_ClearITFlag(URT3,URT_IT_PE);
         }
         if((URT_Flag & URT_STA_ROVRF_mask_w) && (URT_IT_Msk & URT_INT_ROVR_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT3,URT_IT_ROVR);
         }
         if((URT_Flag & URT_STA_RXTMOF_mask_w) && (URT_IT_Msk & URT_INT_RXTMO_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT3,URT_IT_RXTMO);
         }
         if((URT_Flag & URT_STA_IDTMOF_mask_w) && (URT_IT_Msk & URT_INT_IDTMO_IE_mask_w))
         {
             //To do......
             
             URT_ClearITFlag(URT3,URT_IT_IDTMO);
         }

     }
     if((URT_Flag & URT_STA_TCF_mask_w) && (URT_IT_Msk & URT_INT_TC_IE_mask_w))
     {
         //To do......
         
         URT_ClearITFlag(URT3, URT_IT_TC);
     }
}



/***********************************************************************************
:	void URT0_IRQHandler(void)
:	URT0 жϴ
:	
ز:	  
*************************************************************************************/
void URT0_IRQHandler(void)
{
    uint8_t IRQ_ID;
    
    
    IRQ_ID = EXIC_GetITSourceID(URT0_IRQn);      
    if(IRQ_ID & EXIC_SRC5_ID20_urt0_b0)
    {
        URT0_IRQ();
    }
}

/***********************************************************************************
:	void URT123_IRQHandler(void)
:	URT0 жϴ
:	
ز:	  
*************************************************************************************/
void URT123_IRQHandler(void)
{
    uint8_t IRQ_ID;
    
    
    IRQ_ID = EXIC_GetITSourceID(URT123_IRQn);      
    if(IRQ_ID & EXIC_SRC5_ID21_urt3_b1)
    {
        URT3_IRQ();
    }
}


/*
*************************************************************************************
*/ 



/*
*************************************************************************************
*  Init device
*
*************************************************************************************
*/

/***********************************************************************************
:	void CSC_Init (void)
:	ϵͳʱӳʼ
:	
ز:	  
*************************************************************************************/
void CSC_Init (void)
{
	CSC_PLL_TypeDef CSC_PLL_CFG;
    
	
    UnProtectModuleReg(MEMprotect);     	// Setting flash wait state
    MEM_SetFlashWaitState(MEM_FWAIT_ONE);	// 50MHz> Sysclk >=25MHz
    ProtectModuleReg(MEMprotect);

    UnProtectModuleReg(CSCprotect);
	CSC_CK_APB_Divider_Select(APB_DIV_1);	// Modify CK_APB divider	APB=CK_MAIN/1
	CSC_CK_AHB_Divider_Select(AHB_DIV_1);	// Modify CK_AHB divider	AHB=APB/1

#if (_CK_SEL_==_CK_IHRCO_)	
	/* CK_HS selection */
	CSC_IHRCO_Select(IHRCO_12MHz);			// IHRCO Sel 12MHz
	CSC_IHRCO_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_IHRCOF) == DRV_Normal);
	CSC_ClearFlag(CSC_IHRCOF);
	CSC_CK_HS_Select(HS_CK_IHRCO);			// CK_HS select IHRCO


	/* PLL */
	/**********************************************************/
	CSC_PLL_CFG.InputDivider=PLLI_DIV_2;	// 12M/2=6M
	CSC_PLL_CFG.Multiplication=PLLIx16;		// 6M*16=96M
	CSC_PLL_CFG.OutputDivider=PLLO_DIV_2;	// PLLO=96M/2=48M
	CSC_PLL_Config(&CSC_PLL_CFG);
	CSC_PLL_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_PLLF) == DRV_Normal);
	CSC_ClearFlag(CSC_PLLF);
	/**********************************************************/

	
	/* CK_MAIN */ 
	CSC_CK_MAIN_Select(MAIN_CK_PLLO);	
#else
	
	/* CK_HS selection */
	CSC_XOSCGain_Select(Gain_Medium);		
	CSC_PeriphOnModeClock_Config(CSC_ON_PortC, ENABLE);
	CSC_XOSC_Cmd(ENABLE);					// Enable XOSC
	while(CSC_GetSingleFlagStatus(CSC_XOSCF) == DRV_Normal);
	CSC_ClearFlag(CSC_XOSCF);
	
	CSC_MissingClockDetectionDuration_Select(MCD_Duration_125us);
	CSC_MissingClockDetection_Cmd(ENABLE);

	CSC_CK_HS_Select(HS_CK_XOSC);
	
	/* PLL */
	/**********************************************************/
	CSC_PLL_CFG.InputDivider=PLLI_DIV_2;	// 12M/2=65M
	CSC_PLL_CFG.Multiplication=PLLIx16;		// 6M*16=96M
	CSC_PLL_CFG.OutputDivider=PLLO_DIV_2;	// PLLO=96M/2=48M
	CSC_PLL_Config(&CSC_PLL_CFG);
	CSC_PLL_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_PLLF) == DRV_Normal);
	CSC_ClearFlag(CSC_PLLF);
	/**********************************************************/

	
	/* CK_MAIN */ 
	CSC_CK_MAIN_Select(MAIN_CK_PLLO);	
#endif

    ProtectModuleReg(CSCprotect);
    
}

/***********************************************************************************
:	void TICK_Init (void)
:	ϵͳδʱӳʼ 
:	
ز:	  
*************************************************************************************/
void TICK_Init (void)
{
	InitTick(SYS_CLOCK*1000000,0);
	NVIC_EnableIRQ(SysTick_IRQn);
}

/***********************************************************************************
:	void GPIO_Init(void)
:	ͨIOڳʼ
:	
ز:	  
*************************************************************************************/
void GPIO_Init(void)
{
	PIN_InitTypeDef PINX_InitStruct;
    
	//==Set GPIO Clock
    UnProtectModuleReg(CSCprotect);
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortE,ENABLE);						// Enable PortE Clock
    ProtectModuleReg(CSCprotect);
    
	//==Set GPIO init
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 		// Pin select Push Pull mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_Low;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse

	PINX_InitStruct.PINX_Alternate_Function  = PE13_AF_GPE13;				// Pin AFS = GPIO
	GPIO_PinMode_Config(PINE(13),&PINX_InitStruct); 					 		// 

	PINX_InitStruct.PINX_Alternate_Function  = PE14_AF_GPE14;				// Pin AFS = GPIO
	GPIO_PinMode_Config(PINE(14),&PINX_InitStruct); 					 		// 

	PINX_InitStruct.PINX_Alternate_Function  = PE15_AF_GPE15;				// Pin AFS = GPIO
	GPIO_PinMode_Config(PINE(15),&PINX_InitStruct); 					 	// 
  
}

/***********************************************************************************
:	void URT0_Init(void)
:	UART0ʼ 
		  TXD(PC10),RXD(PBC11)
		  8,n,1 19200bps@48MHz
:	
ز:	  
*************************************************************************************/
void URT0_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
    
	PIN_InitTypeDef PINX_InitStruct;

	//==Set URT0 Clock
    UnProtectModuleReg(CSCprotect);
	CSC_PeriphProcessClockSource_Config(CSC_UART0_CKS, CK_APB);
 	CSC_PeriphOnModeClock_Config(CSC_ON_UART0,ENABLE);						// Enable UART0 Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortB,ENABLE);						// Enable PortB Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortC,ENABLE);						// Enable PortC Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortE,ENABLE);						// Enable PortE Clock
    ProtectModuleReg(CSCprotect);
    
	//==Set GPIO init
	//PB8 PPO TX ,PB9 ODO RX
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_High;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
	
#if (URT0_TX_USE == URT0_TX_PB8)	
	PINX_InitStruct.PINX_Alternate_Function  = PB8_AF_URT0_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINB(8),&PINX_InitStruct); 					 		// TXD at PB8
#endif
#if (URT0_TX_USE == URT0_TX_PC5)
	PINX_InitStruct.PINX_Alternate_Function  = PC5_AF_URT0_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINC(5),&PINX_InitStruct); 					 		// TXD at PC5
#endif
#if (URT0_TX_USE == URT0_TX_PC10)
	PINX_InitStruct.PINX_Alternate_Function  = PC10_AF_URT0_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINC(10),&PINX_InitStruct); 					 	// TXD at PC10
#endif
#if (URT0_TX_USE == URT0_TX_PE0)
	PINX_InitStruct.PINX_Alternate_Function  = PE0_AF_URT0_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINE(0),&PINX_InitStruct); 					 		// TXD at PE0
#endif
	
#if (URT0_RX_USE == URT0_RX_PB9)	
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PB9_AF_URT0_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINB(9),&PINX_InitStruct); 					 		// RXD at PB9
#endif
#if (URT0_RX_USE == URT0_RX_PC4)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PC4_AF_URT0_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINC(4),&PINX_InitStruct); 					 		// RXD at PC4
#endif
#if (URT0_RX_USE == URT0_RX_PC11)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PC11_AF_URT0_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINC(11),&PINX_InitStruct); 					 	// RXD at PC11
#endif
#if (URT0_RX_USE == URT0_RX_PE1)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PE1_AF_URT0_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINE(1),&PINX_InitStruct); 					 		// RXD at PE1
#endif

    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InternalClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                	//Set PSR
    URT_BRG.URT_BaudRateCounterReload = 99;	                	//Set RLR
    URT_BaudRateGenerator_Config(URT0, &URT_BRG);		    	//BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URT0, ENABLE);	            	//Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URT0, URT_TXClock_Internal);		//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URT0, URT_RXClock_Internal);		//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URT0, 24);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URT0, 24);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URT0, URT_RXSMP_3TIME);
    URT_TX_Cmd(URT0, ENABLE);	                            	//Enable TX
    URT_RX_Cmd(URT0, ENABLE);	                            	//Enable RX
    
    

    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URT0, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URT0, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URT0, URT_DataLine_2);
    
    //=====Set Error Control=====//
    // to do...
    
    //=====Set Bus Status Detect Control=====//
    // to do...
    
    //=====Set Data Control=====//
    URT_RXShadowBufferThreshold_Select(URT0, URT_RXTH_1BYTE);
    URT_IdlehandleMode_Select(URT0, URT_IDLEMode_No);
    URT_TXGuardTime_Select(URT0, 0);
    
    //=====Enable URT Interrupt=====//
    URT_IT_Config(URT0, URT_IT_RX, ENABLE);
    URT_ITEA_Cmd(URT0, ENABLE);
    NVIC_EnableIRQ(URT0_IRQn);

    //=====Enable URT=====//
    URT_Cmd(URT0, ENABLE);
		
}

/***********************************************************************************
:	void URT1_Init(void)
:	UART1ʼ 
		  8,n,1 115200bps@48MHz
:	
ز:	  
*************************************************************************************/
void URT1_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
    
	PIN_InitTypeDef PINX_InitStruct;

	//==Set URT0 Clock
    UnProtectModuleReg(CSCprotect);
	CSC_PeriphProcessClockSource_Config(CSC_UART1_CKS, CK_APB);
 	CSC_PeriphOnModeClock_Config(CSC_ON_UART1,ENABLE);						// Enable UART0 Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortC,ENABLE);						// Enable PortC Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortD,ENABLE);						// Enable PortD Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortE,ENABLE);						// Enable PortE Clock
    ProtectModuleReg(CSCprotect);
    
	//==Set GPIO init
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_High;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
	
#if (URT1_TX_USE == URT1_TX_PC8)	
	PINX_InitStruct.PINX_Alternate_Function  = PC8_AF_URT1_TX;				// Pin AFS = URT1_TX
	GPIO_PinMode_Config(PINC(8),&PINX_InitStruct); 					 		// TXD at PC8
#endif
#if (URT1_TX_USE == URT1_TX_PC5)
	PINX_InitStruct.PINX_Alternate_Function  = PC5_AF_URT1_TX;				// Pin AFS = URT1_TX
	GPIO_PinMode_Config(PINC(5),&PINX_InitStruct); 					 		// TXD at PC5
#endif
#if (URT1_TX_USE == URT1_TX_PD4)
	PINX_InitStruct.PINX_Alternate_Function  = PD4_AF_URT1_TX;				// Pin AFS = URT1_TX
	GPIO_PinMode_Config(PINC(10),&PINX_InitStruct); 					 	// TXD at PD4
#endif
#if (URT1_TX_USE == URT1_TX_PE2)
	PINX_InitStruct.PINX_Alternate_Function  = PE2_AF_URT1_TX;				// Pin AFS = URT1_TX
	GPIO_PinMode_Config(PINE(2),&PINX_InitStruct); 					 		// TXD at PE2
#endif
	
#if (URT1_RX_USE == URT1_RX_PC9)	
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PC9_AF_URT1_RX;				// Pin AFS = URT1_RX
	GPIO_PinMode_Config(PINC(9),&PINX_InitStruct); 					 		// RXD at PC9
#endif
#if (URT1_RX_USE == URT1_RX_PC4)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PC4_AF_URT1_RX;				// Pin AFS = URT1_RX
	GPIO_PinMode_Config(PINC(4),&PINX_InitStruct); 					 		// RXD at PC4
#endif
#if (URT1_RX_USE == URT1_RX_PD5)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PD5_AF_URT1_RX;				// Pin AFS = URT1_RX
	GPIO_PinMode_Config(PIND(5),&PINX_InitStruct); 					 		// RXD at PD5
#endif
#if (URT1_RX_USE == URT1_RX_PE3)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PE3_AF_URT1_RX;				// Pin AFS = URT1_RX
	GPIO_PinMode_Config(PINE(3),&PINX_InitStruct); 					 		// RXD at PE3
#endif

    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InternalClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                	//Set PSR
    URT_BRG.URT_BaudRateCounterReload = 99;	                	//Set RLR
    URT_BaudRateGenerator_Config(URT1, &URT_BRG);		    	//BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URT1, ENABLE);	            	//Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URT1, URT_TXClock_Internal);		//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URT1, URT_RXClock_Internal);		//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URT1, 24);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URT1, 24);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URT1, URT_RXSMP_3TIME);
    URT_TX_Cmd(URT1, ENABLE);	                            	//Enable TX
    URT_RX_Cmd(URT1, ENABLE);	                            	//Enable RX
    
    

    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URT1, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URT1, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URT1, URT_DataLine_2);
    
    //=====Set Error Control=====//
    // to do...
    
    //=====Set Bus Status Detect Control=====//
    // to do...
    
    //=====Set Data Control=====//
    URT_RXShadowBufferThreshold_Select(URT1, URT_RXTH_1BYTE);
    URT_IdlehandleMode_Select(URT1, URT_IDLEMode_No);
    URT_TXGuardTime_Select(URT1, 0);
    
    //=====Enable URT Interrupt=====//
    //URT_IT_Config(URT1, URT_IT_RX, ENABLE);
    //URT_ITEA_Cmd(URT1, ENABLE);
    //NVIC_EnableIRQ(URT123_IRQn);

    //=====Enable URT=====//
    URT_Cmd(URT1, ENABLE);
		
}

/***********************************************************************************
:	void URT3_Init(void)
:	UART3ʼ 
		  TXD(PC10),RXD(PBC11)
		  8,n,1 19200bps@48MHz
:	
ز:	  
*************************************************************************************/
void URT3_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
    
	PIN_InitTypeDef PINX_InitStruct;

	//==Set URT3 Clock
    UnProtectModuleReg(CSCprotect);
	CSC_PeriphProcessClockSource_Config(CSC_UART3_CKS, CK_APB);
 	CSC_PeriphOnModeClock_Config(CSC_ON_UART3,ENABLE);						// Enable UART0 Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortB,ENABLE);						// Enable PortB Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortD,ENABLE);						// Enable PortC Clock
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortE,ENABLE);						// Enable PortE Clock
    ProtectModuleReg(CSCprotect);
    
	//==Set GPIO init
	//PB8 PPO TX ,PB9 ODO RX
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_High;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
	
#if (URT3_TX_USE == URT3_TX_PB14)	
	PINX_InitStruct.PINX_Alternate_Function  = PB14_AF_URT3_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINB(14),&PINX_InitStruct); 					 		// TXD at PB8
#endif
#if (URT3_TX_USE == URT3_TX_PD8)
	PINX_InitStruct.PINX_Alternate_Function  = PD8_AF_URT3_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PIND(8),&PINX_InitStruct); 					 		// TXD at PC5
#endif
#if (URT3_TX_USE == URT3_TX_PE12)
	PINX_InitStruct.PINX_Alternate_Function  = PE12_AF_URT3_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINE(12),&PINX_InitStruct); 					 	// TXD at PC10
#endif
	
#if (URT3_RX_USE == URT3_RX_PB13)	
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PB13_AF_URT3_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINB(13),&PINX_InitStruct); 					 		// RXD at PB9
#endif
#if (URT3_RX_USE == URT3_RX_PD9)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PD9_AF_URT3_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PIND(9),&PINX_InitStruct); 					 		// RXD at PC4
#endif
#if (URT3_RX_USE == URT3_RX_PE13)
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PE13_AF_URT3_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINE(13),&PINX_InitStruct); 					 	// RXD at PC11
#endif

    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InternalClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                	//Set PSR
    URT_BRG.URT_BaudRateCounterReload = 99;	                	//Set RLR
    URT_BaudRateGenerator_Config(URT3, &URT_BRG);		    	//BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URT3, ENABLE);	            	//Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URT3, URT_TXClock_Internal);		//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URT3, URT_RXClock_Internal);		//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URT3, 24);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URT3, 24);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URT3, URT_RXSMP_3TIME);
    URT_TX_Cmd(URT3, ENABLE);	                            	//Enable TX
    URT_RX_Cmd(URT3, ENABLE);	                            	//Enable RX
    
    

    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URT3, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URT3, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URT3, URT_DataLine_2);
    
    //=====Set Error Control=====//
    // to do...
    
    //=====Set Bus Status Detect Control=====//
    // to do...
    
    //=====Set Data Control=====//
    URT_RXShadowBufferThreshold_Select(URT3, URT_RXTH_1BYTE);
    URT_IdlehandleMode_Select(URT3, URT_IDLEMode_No);
    URT_TXGuardTime_Select(URT3, 0);
    
    //=====Enable URT Interrupt=====//
    URT_IT_Config(URT3, URT_IT_RX, ENABLE);
    URT_ITEA_Cmd(URT3, ENABLE);
    NVIC_EnableIRQ(URT123_IRQn);

    //=====Enable URT=====//
    URT_Cmd(URT3, ENABLE);
		
}


/*
*************************************************************************************
*/ 



/*
*************************************************************************************
*  Function
*
*************************************************************************************
*/
/***********************************************************************************
:	int fputc(int ch,FILE *f)
: , printf
:	
ز:	  
*************************************************************************************/
int fputc(int ch,FILE *f)
{
	
	URT_SetTXData(PRINTF_URTX,1,ch);
	while(URT_GetITSingleFlagStatus(PRINTF_URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(PRINTF_URTX,URT_IT_TC);
	
	return ch;
}

/***********************************************************************************
:	void SendByte(u32 ch)
: 
:	
ز:	  
*************************************************************************************/
void SendByte(u32 ch)
{
	if(ProcUart ==0)
	{
		URT_SetTXData(URT0,1,ch);
		while(URT_GetITSingleFlagStatus(URT0,URT_IT_TC)==DRV_UnHappened);
		URT_ClearITFlag(URT0,URT_IT_TC);
	}
	else if(ProcUart ==3)
	{
		URT_SetTXData(URT3,1,ch);
		while(URT_GetITSingleFlagStatus(URT3,URT_IT_TC)==DRV_UnHappened);
		URT_ClearITFlag(URT3,URT_IT_TC);
	}

}

/***********************************************************************************
:	DRV_Return MEM_FlashAPPageErase(uint32_t StartPageAddress, uint32_t PageQuantity)
: AP
:	
ز:	  
*************************************************************************************/
DRV_Return MEM_FlashAPPageErase(uint32_t StartPageAddress, uint32_t PageQuantity)
{
    DRV_Return lDRV_Return = DRV_Success;
    uint32_t lCount;
    uint32_t *lptrDest_addr;

    // Check IHRCO Enable
    if(CSC->CR0.MBIT.IHRCO_EN == 0)
        return DRV_Failure;

    // Check flash page erase address alignment
    if(((uint32_t)StartPageAddress & 0x03FF) != 0)
        return DRV_Failure;

    if(((StartPageAddress) < 0x18000000) || ((StartPageAddress) >= 0x1A000000))
        return DRV_Failure;

	if(PageQuantity >=128)
		return DRV_Failure;

    lptrDest_addr = (uint32_t *)StartPageAddress;
    lCount = 0;
		
    __MEM_UnProtect();
    __MEM_Enable();
    __MEM_Access_Enable(MEM_ACCESS_AP_WRITE);
    __MEM_SetWriteMode(APErase);
    __MEM_MultipleWriteUnProtect();

    do{
        // Mem Flag Clear.
        MEM->STA.B[0] = (MEM_STA_WPEF_mask_b0 | MEM_STA_EOPF_mask_b0);
        __ISB();
        *lptrDest_addr = 0xFFFFFFFF;
				
        if((MEM->STA.B[0] & (MEM_STA_WPEF_mask_b0 | MEM_STA_EOPF_mask_b0)) != MEM_STA_EOPF_mask_b0)
        {
            lDRV_Return = DRV_Failure;
            break;
        }
				
				lptrDest_addr +=0x100;//1 page=1024bytes,1 address=32bitdata=4bytes,so,1 page address offset=1024/4=0x100

    }while(++lCount < PageQuantity);
		
		

    __MEM_UnProtect();
    __MEM_MultipleWriteProtect();
    __MEM_SetWriteMode(None);
    __MEM_Access_Disable(MEM_ACCESS_AP_WRITE);
    __MEM_Disable();
    __MEM_Protect();

    return lDRV_Return;
}

/***********************************************************************************
:	void Flash_Read_para(uint32_t addr_start, uint16_t len, uint32_t *pdat)
: ȡflash        		addr_startȡݵʼַ				lenݳ 			*pdatָȡݵָ
:	uint32_t addr_start, uint16_t len, uint32_t *pdat
ز:	  
*************************************************************************************/
void Flash_Read_para(uint32_t addr_start, uint16_t len, uint32_t *pdat)
{
	u8 i=0;
	for(i=0;i<len;i++)
	{
	*pdat = *(__IO u8*)(addr_start);
	addr_start++;
	pdat++;
	}
		
}



/***********************************************************************************
:	DRV_Return MEM_FlashAPProgram(uint32_t StartAddress, uint32_t DataStartAddress, uint32_t Length)
: дAP
:	
ز:	  
*************************************************************************************/
DRV_Return MEM_FlashAPProgram(uint32_t StartAddress, uint32_t DataStartAddress, uint32_t Length)
{

    DRV_Return lDRV_Return = DRV_Success;
    uint32_t lCount;
    uint32_t *lptrSrc_addr;
    uint32_t *lptrDest_addr;
    

    // Check IHRCO Enable
    if(CSC->CR0.MBIT.IHRCO_EN == 0)
        return DRV_Failure;

    // Check write flash address alignment
		    if(((StartAddress & 0x03) != 0) && ((DataStartAddress & 0x03) != 0))
        return DRV_Failure;

    if(((StartAddress) < 0x18000000) || ((StartAddress) >= 0x1A000000))
        return DRV_Failure;

    lptrSrc_addr = (uint32_t *)DataStartAddress;
    lptrDest_addr = (uint32_t *)StartAddress;
    lCount = 0;

    __MEM_UnProtect();
    __MEM_Enable();
    __MEM_Access_Enable(MEM_ACCESS_AP_WRITE);
    __MEM_SetWriteMode(APProgram);
    __MEM_MultipleWriteUnProtect();

    do{
        // Mem Flag Clear.
        MEM->STA.B[0] = (MEM_STA_WPEF_mask_b0 | MEM_STA_EOPF_mask_b0);
        __ISB();
        *lptrDest_addr = *lptrSrc_addr;

        if((MEM->STA.B[0] & (MEM_STA_WPEF_mask_b0 | MEM_STA_EOPF_mask_b0)) != MEM_STA_EOPF_mask_b0)
        {
            lDRV_Return = DRV_Failure;
            break;
        }
        lptrSrc_addr ++;
        lptrDest_addr ++;
    }while(++lCount < Length);

    __MEM_UnProtect();
    __MEM_MultipleWriteProtect();
    __MEM_SetWriteMode(None);
    __MEM_Access_Disable(MEM_ACCESS_AP_WRITE);
    __MEM_Disable();
    __MEM_Protect();

    return lDRV_Return;
}


/*
*************************************************************************************
*/ 



/***********************************************************************************
:	void UncodeService(uint8_t *file,uint16_t len)
: λDATAн
:	uint8_t *file,uint16_t len
ز:	  
*************************************************************************************/
void UncodeService(uint8_t *file,uint16_t len)
{
	uint16_t index;
	uint8_t  temp1,temp2;
	for(index=0;index<len;index++)
	{
		temp2=file[index];
		temp2=temp2^SecretKey[index%SecetKeyLenth];
		
		temp1=temp2;
		temp1>>=4; temp2<<=4;
		temp2 |=temp1;
		
		file[index]=temp2;
	}
}

/***********************************************************************************
:	void SendCMD(u8 CID1,u8 CID2,u8 CID3,u8 TxData1)
: λרŷ			ָ
:	u8 CID1,u8 CID2,u8 CID3,u8 TxData1
ز:	  
*************************************************************************************/
void SendCMD(u8 CID1,u8 CID2,u8 CID3,u8 TxData1)
{
	WordTypeDef CheckSum;

	CheckSum.W = CID1+CID2+CID3+0x0002+TxData1;
	CheckSum.W = ~(CheckSum.W);
	CheckSum.W = CheckSum.W+0x0001;
	
	SendByte(':');					//֡
	SendByte(':');
	SendByte(':');	
	SendByte(':');

	SendByte(CID1);					//CID֡
	SendByte(CID2);
	SendByte(CID3);

	SendByte(0x00);					//LEN֡
	SendByte(0x02);

	SendByte(0x00);					//ADDR֡:00 00
	SendByte(0x00);

	SendByte(0x00);					//Data֡
	SendByte(TxData1);
				
	SendByte(CheckSum.B.BHigh);		//LRC֡
	SendByte(CheckSum.B.BLow);

	SendByte(0x0D);					//ͽ֡
	SendByte(0x0D);
	SendByte(0x0D);
	SendByte(0x0D);
	
}

/***********************************************************************************
:	void UpgradeProc(void)
: Э
:	
ز:	  
*************************************************************************************/
void UpgradeProc(void)
{
	u8 RxData;
	u8 ProgramCheck =0;
	WordTypeDef RxCheckSum;

	if(UartxRxIn!=UartxRxOut && UartConfirm ==1)				//һֽϢн
	{
		RxData=UarxRxBuf[UartxRxOut];
		UartxRxOut++;
		if(UartxRxOut>=UARTX_RX_BUF_SIZE)
		{
			UartxRxOut=0;
		}
		switch(SysStatus)
		{
			case SYS_IDLE:
				if(RxData == ':')			//ЭʼЭ
				{
					BMSLRCRxData.W = 0x0000;
					RxCheckSum.W = 0x0000;
					SysStatus ++;
					ISPTimeCounting =0;		//óʱλ
					//printf(":1 received!!\n");
				}
				else 
				{
					SysStatus = SYS_IDLE;
				}
			break;
					
			case SYS_WAIT_3A_2:
				if(RxData == ':')
				{
					SysStatus ++;
					//printf(":2 received!!\n");
				}
				else 
				{
					SysStatus = SYS_IDLE;
				}
			break;

			case SYS_WAIT_3A_3:
				if(RxData == ':')
				{
					SysStatus ++;
					//printf(":3 received!!\n");
				}
				else 
				{
					SysStatus = SYS_IDLE;

				}
			break;
			
			case SYS_WAIT_3A_4:
				if(RxData == ':')
				{
					SysStatus ++;
					//printf(":4 received!!\n");
				}
				else 
				{
					SysStatus = SYS_IDLE;
				}
			break;	

			case SYS_WAIT_CID1:
				if(RxData == 'W')
				{
					RxCID1 = RxData;
					SysStatus ++;
					RxCheckSum.W += RxCID1;		
					//printf("CID1 received!!\n");
				}
				else if(RxData == 'R')
				{
					RxCID1 = RxData;
					SysStatus ++;
					RxCheckSum.W += RxCID1;
					//printf("CID1 received!!\n");
				}
				else
				{
					SysStatus = SYS_IDLE;
				}
				
			break;	
				
			case SYS_WAIT_CID2:
				if(RxData == 'E')
				{
					WriteEnable = 1;
					RxCID2 = RxData;
					SysStatus ++;
					RxCheckSum.W += RxCID2;
					//printf("CID2 received!!\n");
				}
				else if(RxData == 'F')
				{
					RxCID2 = RxData;
					SysStatus ++;
					RxCheckSum.W += RxCID2;
					//printf("CID2 received!!\n");
				}
				else
				{
					SysStatus = SYS_IDLE;
					SendCMD(RxCID1, RxCID2, 'N', 0x01);  //֡У
				}
				
			break;	
				
			case SYS_WAIT_CID3:
				if(RxData == 'D')
				{
					RxCID3 = RxData;
					SysStatus ++;
					RxCheckSum.W += RxCID3;   			//У
					//printf("CID3 received!!\n");
				}
				else if(RxData == 'L')
				{
					RxCID3 = RxData;
					SysStatus = SYS_WAIT_ADDR_H; 		//ڸCID״ֽ̬Ϣ֡Ϊ˲Ӱ̣αֽڳ,LENϢ֡ԼЭ
					BMSRxLen.W = 0x0002;
					RxCheckSum.W += RxCID3;   			//У
					//printf("CID3 received!!\n");
				}
				else if(RxData == 'G')
				{
					RxCID3 = RxData;
					SysStatus = SYS_WAIT_ADDR_H; 		//ڸCID״ֽ̬Ϣ֡Ϊ˲Ӱ̣αֽڳ,LENϢ֡ԼЭ
					BMSRxLen.W = 0x0002;
					RxCheckSum.W += RxCID3;   			//У
					//printf("CID3 received!!\n");
				}
				else if(RxData == 'B')
				{
					RxCID3 = RxData;
					SysStatus ++;
					RxCheckSum.W += RxCID3;   			//У
					//printf("CID3 received!!\n");
				}
				else if(RxData == 'N')
				{
					RxCID3 = RxData;
					SysStatus ++;
					RxCheckSum.W += RxCID3;   			//У
					//printf("CID3 received!!\n");
				}
				else if(RxData == 'E')
				{
					RxCID3 = RxData;
					SysStatus = SYS_WAIT_ADDR_H; 		//ڸCID״ֽ̬Ϣ֡Ϊ˲Ӱ̣αֽڳ,LENϢ֡ԼЭ
					BMSRxLen.W = 0x0002;
					RxCheckSum.W += RxCID3;   			//У
					//printf("CID3 received!!\n");
				}
				else
				{
					SysStatus = SYS_IDLE;
				}
				
			break;	

			case SYS_WAIT_LEN_H:
				BMSRxLen.B.BHigh = RxData;		
				SysStatus++;
				RxCheckSum.W += BMSRxLen.B.BHigh;   			//У
				//printf("LENH received!!\n");
			break;
				
			case SYS_WAIT_LEN_L:
				BMSRxLen.B.BLow = RxData;
				SysStatus++;
				BMSDCount = BMSRxLen.W;
				RxCheckSum.W += BMSRxLen.B.BLow;   			//У				
				//printf("LENL received!!\n");
			break;

			case SYS_WAIT_ADDR_H:
				BMSRxADDR.B.BHigh = RxData;
				SysStatus++;
				RxCheckSum.W += BMSRxADDR.B.BHigh;   			//У
				//printf("ADDRH received!!\n");
			break;
				
			case SYS_WAIT_ADDR_L:
				BMSRxADDR.B.BLow = RxData;
				SysStatus++;
				BMSDCount =0;
				RxCheckSum.W += BMSRxADDR.B.BLow;   			//У
				//printf("ADDRL received!!\n");
			break;

			case SYS_WAIT_DATA:
			
				BMSRxData[BMSDCount] = RxData;					//ݴ뻺壬ڸAP
				RxCheckSum.W += BMSRxData[BMSDCount];   			//У
				BMSDCount++;
				if(BMSDCount >= BMSRxLen.W)						//յݺһ״̬
				{
					SysStatus++;
					BMSDCount = 0;
				}
				
				//printf("DATA received!!\n");
			break;

			case SYS_WAIT_LRC_H:
				BMSLRCRxData.B.BHigh = RxData;	
				SysStatus++;
				//printf("LRCH received!!\n");
			break;	

			case SYS_WAIT_LRC_L:
				BMSLRCRxData.B.BLow = RxData;
				SysStatus++;
				//printf("LRCL received!!\n");
			break;
				
			case SYS_WAIT_0D_1:
				if(RxData == 0x0D)
				{
					SysStatus ++;
					//printf("0D1 received!!\n");
					
				}
				else 
				{
					SysStatus = SYS_IDLE;
				}
			break;	

			case SYS_WAIT_0D_2:
				if(RxData == 0x0D)
				{
					SysStatus ++;
					//printf("0D2 received!!\n");
					
				}
				else 
				{
					SysStatus = SYS_IDLE;
				}
			break;	

			case SYS_WAIT_0D_3:
				if(RxData == 0x0D)
				{
					SysStatus ++;
					//printf("0D3 received!!\n");
					
				}
				else 
				{
					SysStatus = SYS_IDLE;
				}
			break;	

			case SYS_WAIT_0D_4:
				if(RxData == 0x0D)
				{
					SysStatus ++;
					//printf("0D4 received!!\n");
					
				}
				else 
				{
					SysStatus = SYS_IDLE;
				}
			

			case SYS_CHECKSUM:
				RxCheckSum.W = ~(RxCheckSum.W) +1;		//֡У飨ȡ+1
				if(RxCheckSum.W == BMSLRCRxData.W)		//ȶ16λݾͬ봦
				{
					SysStatus++;
					CheckOK =1;							//ʹܷУȷ
				}
				else
				{
					SysStatus = SYS_IDLE;
					SendCMD(RxCID1, RxCID2, 'N', 0x01);//У
					break;
				}
			
			case SYS_HANDLE:						//Уɹдù̲Ӧʱ
				TxCID1 = RxCID1;					//׼ͨŵ3CID
				TxCID2 = RxCID2;
				TxCID3 = 'B';
			
				if(RxCID1 == 'R')
				{
					if(RxCID3 == 'L')			//ѯʰʹ
					{
						BMSTxLen.W = 0x0002;
						BMSTxADDR.W = 0x0000;
						BMSTxData[0] = 0x04;	//MG32F02AÿҳΪ1024ֽڣ0x400ÿν1024ֽݼ
						BMSTxData[1] = 0x00;
					}
					
					if(RxCID3 == 'G')			//λλ
					{	
						ResetEnable =1;			//ʹܸλ
						BMSTxLen.W = 0x0002;
						BMSTxADDR.W = 0x0000;
						BMSTxData[0] = 0x04;
						BMSTxData[1] = 0x00;
					}
					
				}

				if(RxCID1 == 'W')
				{
					if(RxCID3 == 'E')			//λݷ
					{
						WriteEnable =1;			//ʹݶд
						BMSTxLen.W = 0x0002;
						BMSTxADDR.W = 0x0000;
						BMSTxData[0] = 0x04;
						BMSTxData[1] = 0x00;
						
					}

					if(RxCID3 == 'G')			//λλ
					{
						ResetEnable =1;
					}

					if(RxCID3 == 'D' && WriteEnable == 1)   	//ݲ
					{
						DFUPageCnt.W=BMSRxLen.W/1024;			//MG32F02AÿҳΪ1024ֽڣһжҳ
						if((BMSRxLen.W&0x3FF)!=0)				
						{
							DFUPageCnt.W++;						//һҳİ1ҳ
						}

						UncodeService(BMSRxData,1024);			//ݻݽ
						
						if(MEM_FlashAPPageErase(FLASH_AP_STARTADDRESS+(BMSRxADDR.W*16),DFUPageCnt.W)==DRV_Success)		//APҳ*16Ϊѹַ
						{
							if(MEM_FlashAPProgram(FLASH_AP_STARTADDRESS+(BMSRxADDR.W*16),(uint32_t)(BMSRxData), ((sizeof(BMSRxData)) / 4))==DRV_Success)//APд
							{
								ProgramCheck = 1;		//дɹʹܻظ쳣
							}
						}
					}
		
				}

				SysStatus++;

			case SYS_SENDCMD:		//ͻشЭ
				if(RxCID3 =='L'||RxCID3 =='E'||RxCID3=='G')	//DATAЧݰ
				{
					BMSTxData[0] = 0x04;
					BMSTxData[1] = 0x00;
				}
				else
				{
					BMSTxData[0] = 0x00;
					if(CheckOK)				//У
					{
						if(ProgramCheck ==1)	//APд
						{
							BMSTxData[1] = 0x00;
						}
						CheckOK =0;
					}

					else
					{
						BMSTxData[1] = 0x01;
					}
				}
				
				BMSLRCTxData.W = TxCID1+TxCID2+TxCID3+BMSTxLen.W+BMSTxData[0]+BMSTxData[1];
				BMSLRCTxData.W = ~(BMSLRCTxData.W);
				BMSLRCTxData.W = BMSLRCTxData.W+0x0001;		//㷢ЭУ֡
				
				SendByte(':');		//֡
				SendByte(':');
				SendByte(':');	
				SendByte(':');

				SendByte(TxCID1);	//CID֡
				SendByte(TxCID2);
				SendByte(TxCID3);

				SendByte(BMSTxLen.B.BHigh);		//LEN֡
				SendByte(BMSTxLen.B.BLow);

				SendByte(0x00);				//ADDR֡:00 00
				SendByte(0x00);

				SendByte(BMSTxData[0]);		//Data֡
				SendByte(BMSTxData[1]);
				
				SendByte(BMSLRCTxData.B.BHigh);		//LRC֡
				SendByte(BMSLRCTxData.B.BLow);

				SendByte(0x0D);		//ͽ֡
				SendByte(0x0D);
				SendByte(0x0D);
				SendByte(0x0D);
				
				if(ResetEnable ==1)		//ǰʹܸλܣиλ
				{
					__MEM_UnProtect();
					__MEM_SetBootSelect(AP_Space);
					__MEM_Protect();
					
					RST->KEY.H[0] = 0xA217;
					RST->CR0.B[0] |= RST_CR0_SW_EN_mask_h0;
								
					__ISB();
					
					RST->WE.W |= RST_WE_SW_WE_mask_w;
					PE13=1;
					//__NVIC_SystemReset();
					__ISB();

				}
				SysStatus = SYS_IDLE;
			break;	
						
			
				
		}
		
		
	}
}

/***********************************************************************************
:	int main()
:	
:	
ز:	  
*************************************************************************************/
int main()
{
	CSC_Init();
	GPIO_Init();
	TICK_Init();
	URT0_Init();
	URT3_Init();
	
	while(1)
    {
    	if(LedTime==0)
    	{
			PE14=!PE14;
			LedTime=100;
		}
		if(ISPTime ==0)		//500msʱλAP
		{
			__MEM_UnProtect();
			__MEM_SetBootSelect(AP_Space);
			__MEM_Protect();
					
			RST->KEY.H[0] = 0xA217;
			RST->CR0.B[0] |= RST_CR0_SW_EN_mask_h0;
								
			__ISB();
					
			RST->WE.W |= RST_WE_SW_WE_mask_w;
			PE13=1;
					//__NVIC_SystemReset();
			__ISB();
		}

		UpgradeProc();		//ѯЭ

    }
   
}
