;******************************************************************************
;*                                                                            *
;* @file        startup_MG32x02z.s                                            *
;*                                                                            *
;* @brief       MG32x02z Device vector table for MDK-ARM                      *
;*                                                                            *
;* @par         Project                                                       *
;*              MG32x02z                                                      *
;* @version     V2.6 (Interrupt Table Date : 2018_0116)                       *
;* @date        2018/01/16 15:17 (Startup File Generated Date)                *
;* @author      StartupGen V0.1                                               *
;* @note        Copyright (c) 2014 MegaWin Technology Co., Ltd.               *
;*              All rights reserved.                                          *
;*              This module performs:                                         *
;*                  - Set the initial SP                                      *
;*                  - Set the initial PC == Reset_Handler                     *
;*                  - Set the vector table entries with ISR address           *
;*                  - Branches to __main in the C library                     *
;*                                                                            *
;* Important!   This file is generated by code generator. Do not edit!        *
;*                                                                            *
;* <<< Use Configuration Wizard in Context Menu >>>                           *
;******************************************************************************
;  @attention
; 
;  The vector table area is dummy and will update by StartupGen
;   program to generate a project startup .s file
; 
;*******************************************************************************
;
; Amount of memory (in bytes) allocated for Stack
; Tailor this value to your application needs
; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000400

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000200

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit

                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

__Vectors       DCD     __initial_sp                    ; Top of Stack
                DCD     Reset_Handler                   ; Reset Handler
                DCD     NMI_Handler                     ; NMI Handler
                DCD     HardFault_Handler               ; Hard Fault Handler
                DCD     0                               ; Reserved
                DCD     0                               ; Reserved
                DCD     0                               ; Reserved
                DCD     0                               ; Reserved
                DCD     0                               ; Reserved
                DCD     0                               ; Reserved
                DCD     0                               ; Reserved
                DCD     SVC_Handler                     ; SVCall Handler
                DCD     0                               ; Reserved
                DCD     0                               ; Reserved
                DCD     PendSV_Handler                  ; PendSV Handler
                DCD     SysTick_Handler                 ; SysTick Handler

                ; External Interrupts
                DCD     WWDT_IRQHandler                 ;Window Watchdog
                DCD     SYS_IRQHandler                  ;System global Interrupt
                DCD     0                               ;Reserved
                DCD     EXINT0_IRQHandler               ;EXIC EXINT0
                DCD     EXINT1_IRQHandler               ;EXIC EXINT1
                DCD     EXINT2_IRQHandler               ;EXIC EXINT2
                DCD     EXINT3_IRQHandler               ;EXIC EXINT3
                DCD     COMP_IRQHandler                 ;Analog Comparators global Interrupt
                DCD     DMA_IRQHandler                  ;DMA all channel global Interrupt
                DCD     0                               ;Reserved
                DCD     ADC_IRQHandler                  ;ADC
                DCD     DAC_IRQHandler                  ;DAC
                DCD     TM0x_IRQHandler                 ;Timer TM0x global Interrupt
                DCD     TM10_IRQHandler                 ;Timer TM10
                DCD     TM1x_IRQHandler                 ;Timer TM1x global Interrupt
                DCD     TM20_IRQHandler                 ;Timer TM20
                DCD     TM2x_IRQHandler                 ;Timer TM2x global Interrupt
                DCD     TM3x_IRQHandler                 ;Timer TM3x global Interrupt
                DCD     0                               ;Reserved
                DCD     0                               ;Reserved
                DCD     URT0_IRQHandler                 ;UART URT0
                DCD     URT123_IRQHandler               ;UART URT1/2/3 global Interrupt
                DCD     0                               ;Reserved
                DCD     0                               ;Reserved
                DCD     SPI0_IRQHandler                 ;SPI0
                DCD     0                               ;Reserved
                DCD     0                               ;Reserved
                DCD     0                               ;Reserved
                DCD     I2C0_IRQHandler                 ;I2C0
                DCD     I2Cx_IRQHandler                 ;I2Cx global Interrupt
                DCD     0                               ;Reserved
                DCD     0                               ;Reserved

__Vectors_End

__Vectors_Size  EQU  __Vectors_End - __Vectors

                AREA    |.text|, CODE, READONLY

; Reset handler routine
Reset_Handler    PROC
                 EXPORT  Reset_Handler                  [WEAK]
        IMPORT  __main
        IMPORT  SystemInit  
                 LDR     R0, =SystemInit
                 BLX     R0
                 LDR     R0, =__main
                 BX      R0
                 ENDP

; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler                     [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler               [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler                     [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler                  [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler                 [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT  WWDT_IRQHandler                 [WEAK]
                EXPORT  SYS_IRQHandler                  [WEAK]
                EXPORT  EXINT0_IRQHandler               [WEAK]
                EXPORT  EXINT1_IRQHandler               [WEAK]
                EXPORT  EXINT2_IRQHandler               [WEAK]
                EXPORT  EXINT3_IRQHandler               [WEAK]
                EXPORT  COMP_IRQHandler                 [WEAK]
                EXPORT  DMA_IRQHandler                  [WEAK]
                EXPORT  ADC_IRQHandler                  [WEAK]
                EXPORT  DAC_IRQHandler                  [WEAK]
                EXPORT  TM0x_IRQHandler                 [WEAK]
                EXPORT  TM10_IRQHandler                 [WEAK]
                EXPORT  TM1x_IRQHandler                 [WEAK]
                EXPORT  TM20_IRQHandler                 [WEAK]
                EXPORT  TM2x_IRQHandler                 [WEAK]
                EXPORT  TM3x_IRQHandler                 [WEAK]
                EXPORT  URT0_IRQHandler                 [WEAK]
                EXPORT  URT123_IRQHandler               [WEAK]
                EXPORT  SPI0_IRQHandler                 [WEAK]
                EXPORT  I2C0_IRQHandler                 [WEAK]
                EXPORT  I2Cx_IRQHandler                 [WEAK]


WWDT_IRQHandler
SYS_IRQHandler
EXINT0_IRQHandler
EXINT1_IRQHandler
EXINT2_IRQHandler
EXINT3_IRQHandler
COMP_IRQHandler
DMA_IRQHandler
ADC_IRQHandler
DAC_IRQHandler
TM0x_IRQHandler
TM10_IRQHandler
TM1x_IRQHandler
TM20_IRQHandler
TM2x_IRQHandler
TM3x_IRQHandler
URT0_IRQHandler
URT123_IRQHandler
SPI0_IRQHandler
I2C0_IRQHandler
I2Cx_IRQHandler

                B       .

                ENDP

                ALIGN

;*******************************************************************************
; User Stack and Heap initialization
;*******************************************************************************
                 IF      :DEF:__MICROLIB
                
                 EXPORT  __initial_sp
                 EXPORT  __heap_base
                 EXPORT  __heap_limit
                
                 ELSE
                
                 IMPORT  __use_two_region_memory
                 EXPORT  __user_initial_stackheap
                 
__user_initial_stackheap

                 LDR     R0, =  Heap_Mem
                 LDR     R1, =(Stack_Mem + Stack_Size)
                 LDR     R2, = (Heap_Mem +  Heap_Size)
                 LDR     R3, = Stack_Mem
                 BX      LR

                 ALIGN

                 ENDIF

                 END

;************************ End of file ************************
