/* Includes ------------------------------------------------------------------*/
#include "mg32f10x.h"
#include <stdio.h>

#include "FreeRTOS.h"
#include "task.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static void prvLED1Task(void *pvParameters);
static void prvLED2Task(void *pvParameters);

/* Private functions ---------------------------------------------------------*/

void bspInit()
{
  /* Enable GPIOB clock */
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_BMX1 |RCC_APB1Periph_GPIOB, ENABLE);

  /* Configure PB13 and PB14 in output push-pull mode */
  GPIO_Init(GPIOB, GPIO_Pin_13 |GPIO_Pin_14, GPIO_MODE_OUT |GPIO_OTYPE_PP |GPIO_PUPD_NOPULL |GPIO_SPEED_HIGH);
}


int main(void)
{
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_4);

  /* Configure HCLK clock as SysTick clock source. */
  SysTick_CLKSourceConfig(SysTick_CLKSource_HCLK);

  bspInit();

  xTaskCreate(prvLED1Task, "LED1", configMINIMAL_STACK_SIZE, NULL, 1, NULL);
  xTaskCreate(prvLED2Task, "LED2", configMINIMAL_STACK_SIZE, NULL, 1, NULL);

  /* Start the scheduler. */
  vTaskStartScheduler();

  /* Infinite loop */
  while (1)
  {
  }
}

static void prvLED1Task(void *pvParameters)
{
  while (1)
  {
    GPIO_ToggleBits(GPIOB, GPIO_Pin_14);
    vTaskDelay(500);
  }
}

static void prvLED2Task(void *pvParameters)
{
  while (1)
  {
    GPIO_ToggleBits(GPIOB, GPIO_Pin_13);
    vTaskDelay(250);
  }
}



#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
