
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include "REG_MA82G5Dxx.H"

#define		URTS				0x80
#define		SMOD2				0x40
#define		S1TR				0x10
#define		S1MOD				0x08
#define		S1X12				0x04
#define		MCKS1				0x08
#define		MCKS0				0x04

#define		AFS					0x80
#define		CKCON2				0x40

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

uCHAR tmp;

uCHAR ESF_Flag;


void PageP_Write( uCHAR Addr , uCHAR Data )
{
	IFADRH = 0x00;
	IFADRL = Addr;
	IFD = Data;
	IFMT = 0x04;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
}

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	IFADRH = 0x00;
	IFADRL = Addr;
	IFMT = 0x05;
	ISPCR = ISP_ENABLE;
	SCMD = 0x46;
	SCMD = 0xB9;
	ISPCR = ISP_DISABLE;
	Data = IFD;
	
	return Data;
}



void Stop_WDT(void)
{
	tmp = ENW | CLRW |PS2 |PS1 |PS0;
	PageP_Write(0xE1, tmp);			//WDTCR is 0xE1.
}

void Start_WDT(void)
{
	WDTCR = (NSW | ENW | CLRW |PS2 |PS1 |PS0);		// wdt time=2s
}

void Initial_WDT(void)
{
	PCON1 |= WDTF;			//clear WDTF
	Start_WDT();
	EIE1 |= ESF;			//enable interrupt
	SFIE |= WDTFIE;
}

void INT_SYS(void)	interrupt	10	using	1
{
	PCON1 |= WDTF;			//clear WDTF
	ESF_Flag = 1;			//set ESF flag

}

void main(void)
{
    Initial_WDT();
	EA = 1;
	
	P1 = 0x00;
	P2 = 0x00;
	P3 = 0x00;
	P4 = 0x00;
	P6 = 0x00;
	

	while(1)
	{
		if(ESF_Flag)
		{
			ESF_Flag = 0;
			// to do...
			P30 = ~P30;
		}
		
		PCON0 = 0x02;
	}
}
